package tui

import (
	"fmt"
	"strings"
	"testing"

	"github.com/charmbracelet/lipgloss"
)

const Border = `├───────────────────────────────┬──────────────────────┬──────────────────────┤
│ GPU  Name        Persistence-M│ Bus-Id        Disp.A │ MIG M.   Uncorr. ECC │
│ Fan  Temp  Perf  Pwr:Usage/Cap│         Memory-Usage │ GPU-Util  Compute M. │`

func TestHeader(t *testing.T) {
	m := ModelHeader{}
	cmd := m.Init()
	m.Update(cmd)
	fmt.Println(m.View())
}

func TestBorder(t *testing.T) {
	lines := strings.Split(Border, "\n")
	for _, i := range lines {
		t.Logf("%d", lipgloss.Width(i))
	}
}

func TestAis(t *testing.T) {
	for i := 10; i < 180; i++ {
		str := genXAxis(i)
		if lipgloss.Width(str) != i {
			t.Error("error length")
		}
		fmt.Println(str)
	}
}
