package main

import (
	"get-container/cmd/dcutop/tui"
	"log"
	"os"

	tea "github.com/charmbracelet/bubbletea"
	"github.com/charmbracelet/x/term"
)

func main() {
	w, h, err := term.GetSize(os.Stdout.Fd())
	if err != nil {
		log.Fatalf("error get terminal size: %v", err)
	}
	model := tui.NewModelMain(w, h)
	if _, err := tea.NewProgram(&model).Run(); err != nil {
		log.Fatalf("error create program; %v", err)
	}
	os.Exit(0)
}

// type TickMsg time.Time

// type model struct {
// 	c *tui.MyTimeChart
// }

// func (m *model) Init() tea.Cmd {
// 	m.c = tui.New(100, 20, 0, 100, map[string]lipgloss.Color{"default": lipgloss.Color("#ff2222ff"), "other": lipgloss.Color("#0037ffff")})
// 	return tea.Batch(m.c.Init(), tea.Tick(time.Second, func(t time.Time) tea.Msg {
// 		return TickMsg(t)
// 	}))
// }

// func (m *model) Update(inputMsg tea.Msg) (tea.Model, tea.Cmd) {
// 	switch msg := inputMsg.(type) {
// 	case TickMsg:
// 		randPoint1 := rand.Float64() * 100.0
// 		randPoint2 := rand.Float64() * 100.0
// 		now := time.Now()
// 		timePoint1 := tchart.TimePoint{Time: now, Value: randPoint1}
// 		timePoint2 := tchart.TimePoint{Time: now, Value: randPoint2}
// 		tmsg := tui.MyTimeChartMsg{Points: map[string][]tchart.TimePoint{"default": {timePoint1}, "other": {timePoint2}}}
// 		mm, cmd := m.c.Update(tmsg)
// 		m.c = mm.(*tui.MyTimeChart)
// 		return m, tea.Batch(cmd, tea.Tick(time.Second, func(t time.Time) tea.Msg {
// 			return TickMsg(t)
// 		}))
// 	case tea.KeyMsg:
// 		switch msg.String() {
// 		case "q", "ctrl+c":
// 			return m, tea.Quit
// 		}
// 	}
// 	return m, nil
// }

// func (m *model) View() string {
// 	sty := lipgloss.NewStyle().Border(lipgloss.NormalBorder())
// 	st := sty.SetString(m.c.View()).String()
// 	return st + "\n"
// }

// func main() {
// 	_, err := tea.NewProgram(&model{}).Run()
// 	if err != nil {
// 		log.Fatal(err)
// 	}
// }
