package utils

import (
	"fmt"
	"strings"
)

// 0000:01:00.0    # 域0000，总线01，设备00，功能0
func PCIBus(id uint64, funcId uint) string {
	str := fmt.Sprintf("%X", id)
	fstr := fmt.Sprintf("%X", funcId)
	l := len(str)
	if l == 0 {
		return "0000:00:00." + fstr
	}
	if l <= 2 {
		return "0000:00" + ":" + strings.Repeat("0", 2-l) + str + "." + fstr
	}
	if l <= 4 {
		return "0000:" + strings.Repeat("0", 4-l) + str[:l-2] + ":" + str[l-2:] + "." + fstr
	}
	if l <= 8 {
		return strings.Repeat("0", 8-l) + str[:l-4] + ":" + str[l-4:l-2] + ":" + str[l-2:] + "." + fstr
	}
	strs := str[l-8:]
	return strs[:4] + ":" + str[4:6] + ":" + str[6:8] + "." + fstr
}
