// Package docs Code generated by swaggo/swag. DO NOT EDIT
package docs

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {},
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/all": {
            "get": {
                "description": "获取所有信息（系统负载、DCU 负载、在线用户）",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "获取所有信息（系统负载、DCU 负载、在线用户）",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulResult-backend_AllInfo"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulNoDataResult"
                        }
                    }
                }
            }
        },
        "/dcuload": {
            "get": {
                "description": "获取 DCU 负载信息",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "获取 DCU 负载信息",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulListResult-backend_DCULoad"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulNoDataResult"
                        }
                    }
                }
            }
        },
        "/loginUser": {
            "get": {
                "description": "获取在线用户信息",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "获取在线用户信息",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulListResult-backend_LoginUserInfo"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulNoDataResult"
                        }
                    }
                }
            }
        },
        "/rccl/post": {
            "post": {
                "description": "给出rccl all_reduce_perf参数，执行单机测试",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "给出rccl all_reduce_perf参数，执行单机测试",
                "parameters": [
                    {
                        "description": "rccl all reduce perf args",
                        "name": "args",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/web.RcclArgs"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulResult-backend_RcclTestAllReducePrefResult"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulNoDataResult"
                        }
                    }
                }
            }
        },
        "/rcclinfo": {
            "get": {
                "description": "获取 rccl all_reduce_perf 性能信息",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "获取 rccl all_reduce_perf 性能信息",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulResult-backend_RcclTestAllReducePrefResult"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulNoDataResult"
                        }
                    }
                }
            }
        },
        "/sysload": {
            "get": {
                "description": "获取系统负载信息",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "summary": "获取系统负载信息",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulResult-backend_SysInfo"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/web.RestfulNoDataResult"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "backend.AllInfo": {
            "type": "object",
            "properties": {
                "dcuInfo": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/backend.DCULoad"
                    }
                },
                "loginUserInfo": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/backend.LoginUserInfo"
                    }
                },
                "sysInfo": {
                    "$ref": "#/definitions/backend.SysInfo"
                }
            }
        },
        "backend.DCULoad": {
            "type": "object",
            "properties": {
                "dcuUtilPercent": {
                    "type": "number"
                },
                "fan": {
                    "type": "string"
                },
                "index": {
                    "type": "integer"
                },
                "memTotal": {
                    "type": "integer"
                },
                "memUsed": {
                    "type": "integer"
                },
                "memUsedPercent": {
                    "type": "number"
                },
                "name": {
                    "type": "string"
                },
                "pwrAvg": {
                    "description": "单位是瓦",
                    "type": "number"
                },
                "pwrCap": {
                    "description": "单位是瓦",
                    "type": "number"
                },
                "temp": {
                    "description": "单位是摄氏度",
                    "type": "number"
                }
            }
        },
        "backend.LoginUserInfo": {
            "type": "object",
            "properties": {
                "loginFrom": {
                    "description": "登录方式",
                    "type": "string"
                },
                "loginTime": {
                    "description": "登录时间",
                    "type": "string"
                },
                "name": {
                    "description": "用户名",
                    "type": "string"
                },
                "pid": {
                    "description": "登录的接管进程",
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "tty": {
                    "description": "占用的终端",
                    "type": "string"
                }
            }
        },
        "backend.Metrics": {
            "type": "object",
            "properties": {
                "alg_bw": {
                    "type": "number"
                },
                "bus_bw": {
                    "type": "number"
                },
                "time": {
                    "type": "number"
                },
                "wrong": {
                    "type": "integer"
                }
            }
        },
        "backend.RcclTestAllReducePrefResult": {
            "type": "object",
            "properties": {
                "args": {
                    "description": "执行参数",
                    "type": "string"
                },
                "dtk_path": {
                    "description": "dtk 库路径",
                    "type": "string"
                },
                "raw_output": {
                    "type": "string"
                },
                "results": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/backend.RcclTestItem"
                    }
                },
                "test_version": {
                    "description": "rccl-tests 版本信息",
                    "type": "string"
                },
                "use_device": {
                    "description": "使用的设备列表",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "backend.RcclTestItem": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "in_place": {
                    "$ref": "#/definitions/backend.Metrics"
                },
                "out_of_place": {
                    "$ref": "#/definitions/backend.Metrics"
                },
                "redop": {
                    "type": "string"
                },
                "root": {
                    "type": "integer"
                },
                "size": {
                    "type": "integer"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "backend.SysInfo": {
            "type": "object",
            "properties": {
                "cpuPercent": {
                    "description": "CPU使用率",
                    "type": "number"
                },
                "loadAverage1": {
                    "description": "1分钟内平均负载",
                    "type": "number"
                },
                "loadAverage15": {
                    "description": "15分钟平均负载",
                    "type": "number"
                },
                "loadAverage5": {
                    "description": "5分钟平均负载",
                    "type": "number"
                },
                "memTotal": {
                    "description": "总内存",
                    "type": "integer"
                },
                "memUsage": {
                    "description": "已使用内存",
                    "type": "integer"
                },
                "memUsagePercent": {
                    "description": "已使用内存百分比",
                    "type": "number"
                },
                "swapTotal": {
                    "description": "总swap",
                    "type": "integer"
                },
                "swapUsage": {
                    "description": "已使用swap",
                    "type": "integer"
                },
                "swapUsagePercent": {
                    "description": "已使用swap百分比",
                    "type": "number"
                }
            }
        },
        "web.RcclArgs": {
            "type": "object",
            "properties": {
                "args": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "web.RestfulListResult-backend_DCULoad": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "data": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/backend.DCULoad"
                    }
                },
                "msg": {
                    "type": "string"
                }
            }
        },
        "web.RestfulListResult-backend_LoginUserInfo": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "data": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/backend.LoginUserInfo"
                    }
                },
                "msg": {
                    "type": "string"
                }
            }
        },
        "web.RestfulNoDataResult": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "msg": {
                    "type": "string"
                }
            }
        },
        "web.RestfulResult-backend_AllInfo": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "data": {
                    "$ref": "#/definitions/backend.AllInfo"
                },
                "msg": {
                    "type": "string"
                }
            }
        },
        "web.RestfulResult-backend_RcclTestAllReducePrefResult": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "data": {
                    "$ref": "#/definitions/backend.RcclTestAllReducePrefResult"
                },
                "msg": {
                    "type": "string"
                }
            }
        },
        "web.RestfulResult-backend_SysInfo": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "integer"
                },
                "data": {
                    "$ref": "#/definitions/backend.SysInfo"
                },
                "msg": {
                    "type": "string"
                }
            }
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "1.0",
	Host:             "",
	BasePath:         "/api/cmd",
	Schemes:          []string{},
	Title:            "OpsFlow API",
	Description:      "这是opsflow节点命令在服务模式下的接口文档",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
	LeftDelim:        "{{",
	RightDelim:       "}}",
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
