package logic

import (
	"fmt"
	"os"
	"strings"
	"testing"
	"time"
)

func TestRegExt(t *testing.T) {
	test := " HCU Index: ['5','6']"
	if ReHCUIndex.MatchString(test) {
		t.Log("match")
		f := ReHCUIndex.FindStringSubmatch(test)
		t.Logf("%v", f[1])
	}
}

func TestParse(t *testing.T) {
	content, err := os.ReadFile("./hysmi-pid.log")
	if err != nil {
		t.Error(err)
	}
	s := parse_dcu_info(string(content))
	for _, v := range s {
		t.Logf("%s", v.String())
	}
}

func TestDCUInfo(t *testing.T) {
	s := DCUInfo()
	for _, v := range s {
		t.Logf("%s", v.String())
	}
}

func TestNVIDIAInfo(t *testing.T) {
	start := time.Now
	s := NVIDIAInfo()
	dd := time.Since(start())
	t.Logf("%d ms", dd.Milliseconds())
	for _, v := range s {
		t.Logf("%s", v.String())
	}
}

func formatStr(raw string, l int) string {
	lstr := len(raw)
	if l >= lstr {
		return fmt.Sprintf("%s%s", raw, strings.Repeat(" ", l-lstr))
	}
	return raw[:l]
}

func TestFormatStr(t *testing.T) {
	t.Logf("|%s|", formatStr("hello world", 2))
	t.Logf("|%s|", formatStr("hello world", 20))
}
