package backend

import (
	"encoding/json"
	"os"
	"strings"
	"testing"
)

func TestGetOnlineUser(t *testing.T) {
	lui, err := GetOnlineUser()
	if err != nil {
		t.Error(err)
	}
	for _, v := range lui {
		t.Logf("%+v", v)
	}
	bj, err := json.Marshal(lui)
	if err != nil {
		t.Error(err)
	}
	t.Logf("%s", string(bj))
}

func TestUpdateInfo(t *testing.T) {
	Init()
	defer Shutdown()

	err := DCUSInfoMap.UpdateInfo()
	if err != nil {
		t.Error(err)
	}
	info, lock := DCUSInfoMap.GetInfo()
	defer lock.Unlock()
	for k, v := range info {
		t.Logf("%d: %+v", k, v)
	}

}

func TestGetDCULoad(t *testing.T) {
	Init()
	defer Shutdown()
	load, err := GetDCULoad()
	if err != nil {
		t.Error(err)
	}
	for _, v := range load {
		t.Logf("%+v", v)

		b := []byte(v.Name)
		result := make([]byte, 0, len(b))
		for _, v := range b {
			if v != 0 {
				result = append(result, v)
			} else {
				break
			}
		}
		t.Logf("%s", string(result))
		t.Logf("%d", len(result))
	}
}

func TestReMetricsLine(t *testing.T) {
	content, err := os.ReadFile("./rccl-test-output.log")
	if err != nil {
		t.Error(err)
	}
	output := string(content)
	output = strings.Trim(output, "\n")
	for _, v := range strings.Split(output, "\n") {
		if ReMetricsLine.MatchString(v) {
			t.Log("match")
			s := ReMetricsLine.FindAllStringSubmatch(output, -1)
			for _, v := range s {
				for i, u := range v {
					t.Logf(" %d: %s", i, u)
				}
			}
		}
	}
}

func TestReRcclVersion(t *testing.T) {
	content, err := os.ReadFile("./rccl-test-output.log")
	if err != nil {
		t.Error(err)
	}
	output := string(content)
	output = strings.Trim(output, "\n")
	if ReRcclVersion.MatchString(output) {
		t.Log("match")
		s := ReRcclVersion.FindAllStringSubmatch(output, -1)
		for _, v := range s {
			for i, u := range v {
				t.Logf(" %d: %s", i, u)
			}
		}
	}
}

func TestReDeviceLine(t *testing.T) {
	content, err := os.ReadFile("./rccl-test-output.log")
	if err != nil {
		t.Error(err)
	}
	output := string(content)
	output = strings.Trim(output, "\n")
	lines := strings.Split(output, "\n")
	for _, v := range lines {
		if ReDeviceLine.MatchString(v) {
			s := ReDeviceLine.FindAllStringSubmatch(v, -1)
			for _, v := range s {
				for i, u := range v {
					t.Logf(" %d: %s", i, u)
				}
			}
		}
	}

}

func TestParseRcclOutput(t *testing.T) {
	content, err := os.ReadFile("./rccl-test-output.log")
	if err != nil {
		t.Error(err)
	}
	output := string(content)
	result := ParseRcclOutput(output)
	if result == nil {
		t.Error("error parse output")
	}
	t.Logf("result: %+v", result)
	if len(result.Results) > 0 {
		for _, v := range result.Results {
			if v == nil {
				continue
			}
			t.Logf(" item: %+v", v)
		}
	}
}

func TestFile(t *testing.T) {
	st, err := os.Stat("/usr/bin/bash")
	if err != nil {
		t.Error(err)
	}
	t.Logf("%v", st.Mode().Perm() & 0111 > 0)
}

func TestRcclTestCheck(t *testing.T) {
	a,b,err := AllReducePerf("/home/panyq/wangx/rccl-tests/build-dan")
	if err != nil {
		t.Error(err)
	}
	t.Logf("output: %s", a)
	t.Logf("result: %+v", b)
}