from mmengine.config import read_base

with read_base():
    # from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    # from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..datasets.SuperGLUE_BoolQ.SuperGLUE_BoolQ_gen_883d50 import BoolQ_datasets
    from ..datasets.humaneval.humaneval_gen_8e312c import humaneval_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/qwen1.5-series-chat/'


from opencompass.models import VLLMwithChatTemplate

settings = [
    ('qwen1.5-0.5b-chat-vllm', 'Qwen/Qwen1.5-0.5B-Chat', 1),
    ('qwen1.5-1.8b-chat-vllm', 'Qwen/Qwen1.5-1.8B-Chat', 1),
    ('qwen1.5-4b-chat-vllm', 'Qwen/Qwen1.5-4B-Chat', 1),
    ('qwen1.5-7b-chat-vllm', 'Qwen/Qwen1.5-7B-Chat', 1),
    ('qwen1.5-14b-chat-vllm', 'Qwen/Qwen1.5-14B-Chat', 1),
    ('qwen1.5-32b-chat-vllm', 'Qwen/Qwen1.5-32B-Chat', 1),
    ('qwen1.5-72b-chat-vllm', 'Qwen/Qwen1.5-72B-Chat', 4),
    ('qwen1.5-110b-chat-vllm', 'Qwen/Qwen1.5-110B-Chat', 4),
]

models = []
for abbr, path, num_gpus in settings:
    models.append(
        dict(
            type=VLLMwithChatTemplate,
            abbr=abbr,
            path=path,
            model_kwargs=dict(tensor_parallel_size=num_gpus), # add quantization="awq" or quantization="gptq" to eval quantization models
            max_out_len=1024,
            batch_size=16,
            generation_kwargs=dict(temperature=0),
            run_cfg=dict(num_gpus=num_gpus),
        )
    )