from mmengine.config import read_base

with read_base():
    # from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    # from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..datasets.SuperGLUE_BoolQ.SuperGLUE_BoolQ_gen_883d50 import BoolQ_datasets
    from ..datasets.humaneval.humaneval_gen_8e312c import humaneval_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/mixtral-series-instruct/'


from opencompass.models import VLLMwithChatTemplate

settings = [
    ('mixtral-8x7b-instruct-v0.1-vllm', 'mistralai/Mixtral-8x7B-Instruct-v0.1', 2),
    ('mixtral-8x22b-instruct-v0.1-vllm', 'mistralai/Mixtral-8x22B-Instruct-v0.1', 8),
    ('mixtral-large-instruct-2407-vllm', 'mistralai/Mistral-Large-Instruct-2407', 8),
]

models = []
for abbr, path, num_gpus in settings:
    models.append(
        dict(
            type=VLLMwithChatTemplate,
            abbr=abbr,
            path=path,
            model_kwargs=dict(tensor_parallel_size=num_gpus,gpu_memory_utilization=0.9), # add quantization="awq" or quantization="gptq" to eval quantization models
            max_out_len=256,
            batch_size=16,
            generation_kwargs=dict(temperature=0),
            run_cfg=dict(num_gpus=num_gpus),
        )
    )
