from mmengine.config import read_base

with read_base():
    # from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    # from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..datasets.SuperGLUE_BoolQ.SuperGLUE_BoolQ_gen_883d50 import BoolQ_datasets
    from ..datasets.humaneval.humaneval_gen_8e312c import humaneval_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/mistral-series-instruct/'


from opencompass.models import VLLMwithChatTemplate

settings = [
    ('mistral-7b-instruct-v0.1-vllm', 'mistralai/Mistral-7B-Instruct-v0.1', 1),
    ('mistral-7b-instruct-v0.2-vllm', 'mistralai/Mistral-7B-Instruct-v0.2', 1),
]

models = []
for abbr, path, num_gpus in settings:
    models.append(
        dict(
            type=VLLMwithChatTemplate,
            abbr=abbr,
            path=path,
            model_kwargs=dict(tensor_parallel_size=num_gpus,gpu_memory_utilization=0.9), # add quantization="awq" or quantization="gptq" to eval quantization models
            max_out_len=256,
            batch_size=16,
            generation_kwargs=dict(temperature=0),
            run_cfg=dict(num_gpus=num_gpus),
        )
    )
