from mmengine.config import read_base
from opencompass.models import OpenAI

with read_base():
    # from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    # from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..datasets.SuperGLUE_BoolQ.SuperGLUE_BoolQ_gen_883d50 import BoolQ_datasets
    from ..datasets.humaneval.humaneval_gen_8e312c import humaneval_datasets
    from ..summarizers.example import summarizer

api_meta_template = dict(round=[
    dict(role='HUMAN', api_role='HUMAN'),
    dict(role='BOT', api_role='BOT', generate=True),
], )

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/qwen2.5-series/'

settings = [
    ('qwen2.5-0.5b-instruct-vllm', 'Qwen/Qwen2.5-0.5B-Instruct', 1),
    ('qwen2.5-1.5b-instruct-vllm', 'Qwen/Qwen2.5-1.5B-Instruct', 1),
    ('qwen2.5-3b-instruct-vllm', 'Qwen/Qwen2.5-3B-Instruct', 1),
    ('qwen2.5-7b-instruct-vllm', 'Qwen/Qwen2.5-7B-Instruct', 1),
    ('qwen2.5-14b-instruct-vllm', 'Qwen/Qwen2.5-14B-Instruct', 2),
    ('qwen2.5-32b-instruct-vllm', 'Qwen/Qwen2.5-32B-Instruct', 2),
    ('qwen2_5-72b-instruct-vllm', 'Qwen/Qwen2.5-72B-Instruct', 4),
]

models = []
for abbr, path, num_gpus in settings:
    models.append(
        dict(
            type=OpenAI,
            abbr=abbr,
            path=path,
            openai_api_base='http://0.0.0.0:8000/v1/chat/completions',
            key='ENV',  # The key will be obtained from $OPENAI_API_KEY, but you can write down your key here as well
            meta_template=api_meta_template,
            # query_per_second=1,
            max_out_len=4096,
            max_seq_len=4096,
            batch_size=16,
        )
    )