from mmengine.config import read_base
from opencompass.models import OpenAI

with read_base():
    from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    # from ..datasets.gpqa.gpqa_openai_simple_evals_gen_5aeece import gpqa_datasets
    # from ..datasets.math.math_0shot_gen_393424 import math_datasets
    from ..summarizers.example import summarizer

api_meta_template = dict(round=[
    dict(role='HUMAN', api_role='HUMAN'),
    dict(role='BOT', api_role='BOT', generate=True),
], )

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/llama-series/'

settings = [
    ('llama-3.1-8b-instruct-vllm', 'meta-llama/Meta-Llama-3.1-8B-Instruct', 1),
    ('llama-3.1-70b-instruct-vllm', 'meta-llama/Meta-Llama-3.1-70B-Instruct', 4),
]

models = []
for abbr, path, num_gpus in settings:
    models.append(
        dict(
            type=OpenAI,
            abbr=abbr,
            path=path,
            openai_api_base='http://0.0.0.0:8000/v1/chat/completions',
            key='ENV',  # The key will be obtained from $OPENAI_API_KEY, but you can write down your key here as well
            meta_template=api_meta_template,
            # query_per_second=1,
            max_out_len=100,
            max_seq_len=2048,
            batch_size=32,
            temperature=1,
        )
    )