from mmengine.config import read_base

with read_base():
    # from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    # from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..datasets.SuperGLUE_BoolQ.SuperGLUE_BoolQ_gen_883d50 import BoolQ_datasets
    from ..datasets.humaneval.humaneval_gen_8e312c import humaneval_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/qwen2.5-series/'


from opencompass.models import VLLMwithChatTemplate

settings = [
    ('qwen2.5-0.5b-instruct-vllm', 'Qwen/Qwen2.5-0.5B-Instruct', 1),
    ('qwen2.5-1.5b-instruct-vllm', 'Qwen/Qwen2.5-1.5B-Instruct', 1),
    ('qwen2.5-3b-instruct-vllm', 'Qwen/Qwen2.5-3B-Instruct', 1),
    ('qwen2.5-7b-instruct-vllm', 'Qwen/Qwen2.5-7B-Instruct', 1),
    ('qwen2.5-14b-instruct-vllm', 'Qwen/Qwen2.5-14B-Instruct', 2),
    ('qwen2.5-32b-instruct-vllm', 'Qwen/Qwen2.5-32B-Instruct', 2),
    ('qwen2_5-72b-instruct-vllm', 'Qwen/Qwen2.5-72B-Instruct', 4),
]

models = []
for abbr, path, num_gpus in settings:
    models.append(
        dict(
            type=VLLMwithChatTemplate,
            abbr=abbr,
            path=path,
            model_kwargs=dict(tensor_parallel_size=num_gpus,gpu_memory_utilization=0.9), # add quantization="awq" or quantization="gptq" to eval quantization models
            max_out_len=4096,
            batch_size=16,
            generation_kwargs=dict(temperature=0),
            run_cfg=dict(num_gpus=num_gpus, num_procs=1),
        )
    )
