from mmengine.config import read_base

with read_base():
    # from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    # from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..datasets.SuperGLUE_BoolQ.SuperGLUE_BoolQ_gen_883d50 import BoolQ_datasets
    from ..datasets.humaneval.humaneval_gen_8e312c import humaneval_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/internlm2-series/'


from opencompass.models import VLLM

settings = [
    ('internlm2-1.8b-vllm', 'internlm/internlm2-1_8b', 1),
    ('internlm2-7b-vllm', 'internlm/internlm2-7b', 1),
    ('internlm2-base-7b-vllm', 'internlm/internlm2-base-7b', 1),
    ('internlm2-20b-vllm', 'internlm/internlm2-20b', 2),
    ('internlm2-base-20b-vllm', 'internlm/internlm2-base-20b', 2),
]

models = []
for abbr, path, num_gpus in settings:
    models.append(
        dict(
            type=VLLM,
            abbr=abbr,
            path=path,
            model_kwargs=dict(tensor_parallel_size=num_gpus),
            max_out_len=100,
            max_seq_len=2048,
            batch_size=32,
            generation_kwargs=dict(temperature=0),
            run_cfg=dict(num_gpus=num_gpus, num_procs=1),
        )
    )
