from mmengine.config import read_base

with read_base():
    # from ..datasets.ARC_c.ARC_c_gen_1e0de5 import ARC_c_datasets 
    # from ..datasets.ARC_e.ARC_e_gen_1e0de5 import ARC_e_datasets
    from ..datasets.ceval.ceval_gen_5f30c7 import ceval_datasets
    from ..datasets.SuperGLUE_BoolQ.SuperGLUE_BoolQ_gen_883d50 import BoolQ_datasets
    from ..datasets.humaneval.humaneval_gen_8e312c import humaneval_datasets
    from ..summarizers.example import summarizer

datasets = sum([v for k, v in locals().items() if k.endswith("_datasets") or k == 'datasets'], [])
work_dir = './outputs/internlm2-series/'


from opencompass.models import VLLMwithChatTemplate


settings = [
    ('internlm2-chat-1.8b-vllm', 'internlm/internlm2-chat-1_8b', 1),
    ('internlm2-chat-7b-sft-vllm', 'internlm/internlm2-chat-7b-sft', 1),
    ('internlm2-chat-7b-vllm', 'internlm/internlm2-chat-7b', 1),
    ('internlm2-chat-20b-sft-vllm', 'internlm/internlm2-chat-20b-sft', 1),
    ('internlm2-chat-20b-vllm', 'internlm/internlm2-chat-20b', 2),
]

models = []
for abbr, path, num_gpus in settings:
    models.append(
        dict(
            type=VLLMwithChatTemplate,
            abbr=abbr,
            path=path,
            model_kwargs=dict(tensor_parallel_size=num_gpus),
            max_out_len=1024,
            max_seq_len=32768,
            generation_kwargs=dict(temperature=0),
            run_cfg=dict(num_gpus=num_gpus),
        )
    )
