#!/usr/bin/bash

collect_system_info() {
    log "收集CPU信息..."
    echoAndRun "lscpu" > "$OUTPUT_DIR/cpuinfo.txt" 2>&1

    log "收集内存信息..."
    echoAndRun "free -h" > "$OUTPUT_DIR/meminfo.txt" 2>&1
    echoAndRun "dmidecode -t memory" >> "$OUTPUT_DIR/meminfo.txt" 2>&1

    log "收集网络信息..."
    echoAndRun "ip a" > "$OUTPUT_DIR/network.txt" 2>&1
    echoAndRun "lspci -nn | grep -i -E \"eth|mellanox\"" >> "$OUTPUT_DIR/network.txt" 2>&1

    log "收集系统版本..."
    echoAndRun "cat /etc/os-release" > "$OUTPUT_DIR/os_info.txt" 2>&1
    echoAndRun "uname -a" >> "$OUTPUT_DIR/os_info.txt" 2>&1
	echoAndRun "cat /proc/cmdline" >> "$OUTPUT_DIR/os_info.txt" 2>&1
    echoAndRun "numactl -H" >> "$OUTPUT_DIR/os_info.txt" 2>&1
    echoAndRun "rpm -qf $(which ldd)" >> "$OUTPUT_DIR/os_info.txt" 2>&1
    echoAndRun "ldd --version" >> "$OUTPUT_DIR/os_info.txt" 2>&1
    echoAndRun "strings $(find /usr/ -name libc.so.6)  | grep ^GLIBC_" >> "$OUTPUT_DIR/os_info.txt" 2>&1
    echoAndRun "strings $(find /usr -name libstdc++.so.6)  | grep GLIBCXX" >> "$OUTPUT_DIR/os_info.txt" 2>&1
    # echoAndRun "rpm -qi $(rpm -qf $(which ldd))"  >> "$OUTPUT_DIR/os_info.txt" 2>&1

    log "收集服务器信息..."
    echoAndRun "ipmitool fru" > "$OUTPUT_DIR/hardware.txt" 2>&1
    echoAndRun "ipmitool mc info" >> "$OUTPUT_DIR/hardware.txt" 2>&1
    echoAndRun "dmidecode -s system-product-name" >> "$OUTPUT_DIR/hardware.txt" 2>&1
    echoAndRun "dmidecode -t bios" >> "$OUTPUT_DIR/hardware.txt" 2>&1

}