#!/usr/bin/bash

# 分析错误信息
analyze_errors() {
	
    log "分析关键字 $1 相关错误..."
    
    local error_pattern="$1"
    local error_flags="fail|error|uncorrect|warn|exception"
    
    # 在dmesg和系统日志中搜索
    grep -iE "$error_pattern.*($error_flags)|($error_flags).*$error_pattern" \
        "$OUTPUT_DIR/dmesg.log" "$OUTPUT_DIR/system.log" > "$OUTPUT_DIR/driver_issues.log"
    
    if [ -s "$OUTPUT_DIR/driver_issues.log" ]; then
        log "发现潜在问题："
        [ $QUIET_MODE -eq 0 ] && cat "$OUTPUT_DIR/driver_issues.log"
        return 1
    else
        log "未发现相关错误信息"
        rm -f "$OUTPUT_DIR/driver_issues.log"
        return 0
    fi
}
