#!/usr/bin/bash

declare -A devices_id=(
    ["Z100"]="54b7"
    ["Z100L"]="55b7"
    ["K100"]="62b7"
    ["K100-AI"]="6210"
    ["K100-AI-ECO"]="6211"
    ["BW1000"]="6320"
)

# 构建反向映射表（设备ID → 设备名称）
declare -A devices
for name in "${!devices_id[@]}"; do
    id="${devices_id[$name]}"
    devices["${id}"]+=" $name" 
done

get_dcu() {
    # 获取设备ID列表
    mapfile -t dcu_list < <(lspci -nn | grep -i -E "display|co-processor" | awk -F'[][]' '{print $4}' | awk -F ":" '{print $2}')

    local index=0
    local dcu_num=0
    local total=${#dcu_list[@]}

    while [ $index -lt $total ]; do
        current_id="${dcu_list[$index]}"

        if [ -n "${devices[$current_id]}" ]; then
            echo "dcu #$dcu_num 型号为：${devices[$current_id]}"
            ((dcu_num++))
        else
            echo "未知设备ID: $current_id" >&2
        fi

        ((index++))
    done
	echo "总计: $dcu_num张${devices[$current_id]} DCU 设备"
	DEVICE_NAME=${devices[$current_id]}
	DEVICE_ID=$current_id
	# echo $DEVICE_NAME $DEVICE_ID
}
