#!/usr/bin/bash

# 带大小限制的日志复制函数
copy_log_with_limit() {
    local src=$1
    local dest=$2
    local size_limit_mb=$3
    
    if [ -f "$src" ]; then
        file_size=$(du -m "$src" | cut -f1)
        if [ $file_size -gt $size_limit_mb ]; then
            log "跳过大文件: $src (${file_size}MB > ${size_limit_mb}MB)"
            echo "[日志文件超过大小限制未采集]" > "$dest"
            return
        fi
        cp "$src" "$dest" 2>/dev/null || echo "无权限读取日志" > "$dest"
    else
        echo "日志文件不存在" > "$dest"
    fi
}


# 收集系统日志
collect_logs() {
    log "收集系统日志(最近${LOG_AGE}小时)..."
    
    # 识别系统日志位置
    local syslog_path
    [ -f /var/log/syslog ] && syslog_path=/var/log/syslog
    [ -f /var/log/messages ] && syslog_path=/var/log/messages

    if [ -n "$syslog_path" ]; then
        copy_log_with_limit "$syslog_path" "$OUTPUT_DIR/system.log" $LOG_SIZE_LIMIT
    else
        log "收集journalctl日志..."
        journalctl --since "${LOG_AGE} hours ago" > "$OUTPUT_DIR/system.log" 2>/dev/null || \
        echo "无法获取系统日志" > "$OUTPUT_DIR/system.log"
    fi

    log "收集dmesg日志..."
    dmesg -T > "$OUTPUT_DIR/dmesg.log" 2>&1
}