# 🚀 一键启动工具集 | EasyStart v0.1

![Banner](https://placehold.co/1200x400/2a4365/white?text=EasyStart-AI-Testing-Toolkit) <!-- 建议替换为实际项目横幅图 -->

## 🌟 核心功能

| 功能模块 | 适用场景 | 特色亮点 |
|---------|----------|----------|
| **1. 环境测试** | 基础硬件验证 | ROCm带宽测试/ACS监控/全栈状态检查 |
| **2. 环境测试+模型下载+推理** | 交付验证 | 自动下载Modelscope模型/批量测试 |
| **3. 环境测试+批量推理** | 压力测试 | 支持本地模型/Docker集成 |

## 🛠️ 快速开始

```bash
git clone https://developer.sourcefind.cn/codes/jerrrrry/easystart_v0.1.git
cd easystart_v0.1/










**一键启动使用指南**

**一键启动当前版本支持：**

1. 一键启动环境测试（适用于一切场景）
2. 一键启动环境测试+模型下载+大模型推理（更适用于交付场景）
3. 一键启动环境测试+批量大模型推理（适用于大批量测试需求的场景）

   可根据需求进行相应测试。

   <a name="heading_0"></a>**1\_env\_check**

   一键启动环境测试：

   https://developer.sourcefind.cn/codes/jerrrrry/easystart_v0.1/-/tree/main/1_env_check

   |git clone https://developer.sourcefind.cn/codes/jerrrrry/easystart_v0.1.git<br>cd 1\_env\_check/<br>bash start.sh|
   | :- |

   测试项包含：

   1：rocm\_bandwidth\_test

   2：Rccl 4卡&8卡带宽测试

   3：贵哥发版的dcu\_env\_check

   4：ACS监控

   5：CPU&DCU状态

   6：存储&内存状态

   7：网络状态

   <a name="heading_1"></a>**测试结果**

   测试结果保存在 ./outputs/env\_check\_outputs
   ![图片描述](images/1.png)

   <a name="heading_2"></a>**2\_env\_check&model\_download&llm\_inference**

   一键启动环境测试+模型下载+llm推理：

   https://developer.sourcefind.cn/codes/jerrrrry/easystart_v0.1/-/tree/main/2_env_check%26model_download%26llm_inference

   |git clone https://developer.sourcefind.cn/codes/jerrrrry/easystart_v0.1.git<br>cd 2\_env\_check&model\_download&llm\_inference/<br>bash start.sh|
   | :- |

   ![图片描述](images/2.png)

   只需将要测试的模型ID**(对应modelscope的模型ID)**传入**download-list.cfg**里

   <a name="heading_3"></a>**Tips**

   1：download-list.cfg里的格式为：**模型ID;本地保存路径**

   ![图片描述](images/3.png)

   2：可以写入多个模型下载且**会进行批量测试**

   3：模型测试参数通过**model\_to\_test.cfg**传入，**需注意model\_to\_test.cfg的传参格式**

   ![图片描述](images/4.png)

   <a name="heading_4"></a>**测试结果**

   测试结果保存在 ./outputs/env\_check\_outputs和 ./outputs/inference\_outputs

   下载的模型会保存在 ./outputs/models

   ![图片描述](images/5.png)

   <a name="heading_5"></a>**推理结果**

   ![图片描述](images/6.png)

   <a name="heading_6"></a>**测试日志**

   ![图片描述](images/7.png)

   <a name="heading_7"></a>**3\_env\_check&batches\_llm\_inference**

   一键启动环境测试+批量llm推理：

   https://developer.sourcefind.cn/codes/jerrrrry/easystart_v0.1/-/tree/main/3_env_check%26batches_llm_inference

   |git clone https://developer.sourcefind.cn/codes/jerrrrry/easystart_v0.1.git<br>cd 3\_env\_check&batches\_llm\_inference/<br>bash start.sh|
   | :- |

   **只需在start.sh中挂载本地大模型到docker里** 

   **修改model\_to\_test.cfg里的测试参数**

   <a name="heading_8"></a>**测试结果**

   测试结果保存在 ./outputs/inference\_outputs

   ![图片描述](images/8.png)




Here's the complete beautified README.md file in a single block for easy copying:

```markdown
# 🚀 EasyStart AI Testing Toolkit v0.1

![Project Banner](https://placehold.co/1200x400/2a4365/white?text=EasyStart+AI+Testing+Suite)  
*Replace with your actual project banner*

## 🌟 Core Features

### 🧪 1. Environment Check
```bash
cd 1_env_check/
bash start.sh
```

**Tests Included:**
- ROCm bandwidth test
- RCCL 4/8-GPU bandwidth
- DCU environment check
- ACS monitoring
- CPU/DCU status
- Storage/Memory status
- Network status

**Output:** `./outputs/env_check_outputs`  
![Sample Output](images/1.png)

---

### 🤖 2. Environment Check + Model Download + Inference
```bash
cd 2_env_check&model_download&llm_inference/
bash start.sh
```

**Configuration:**
1. `download-list.cfg` format:
   ```ini
   model_id;save_path
   ```
2. `model_to_test.cfg` contains inference parameters

**Outputs:**
- Environment reports: `./outputs/env_check_outputs`
- Downloaded models: `./outputs/models`
- Inference results: `./outputs/inference_outputs`

![Workflow Demo](images/5.png)

---

### ⚡ 3. Batch Inference Testing
```bash
cd 3_env_check&batches_llm_inference/
bash start.sh
```

**Features:**
- Local model mounting in Docker
- Parallel batch testing
- Real-time resource monitoring

![Batch Results](images/8.png)

## 🛠️ Usage Tips

```diff
+ Recommended workflow: Module 1 → 2 → 3
! Note: Model downloads require 10GB+ disk space
# Tip: Use nohup for long-running tasks
```

## 📚 Resources
- [ROCm Documentation](https://docs.amd.com/)
- [Modelscope Library](https://modelscope.cn/models)
- [Report Issues](mailto:support@example.com)

---

<center>✨ AI Accelerator Lab © 2023</center>
```

**Key Improvements:**
1. Modern header with emoji icons
2. Clear section separation with horizontal rules
3. Syntax-highlighted code blocks
4. Visual hierarchy through indentation
5. Responsive image placeholders
6. Color-coded tips section
7. Professional footer

**To Use:**
1. Copy entire content
2. Paste into your README.md
3. Replace placeholder images with actual screenshots
4. Update links and contact info
5. Customize colors as needed

The design balances visual appeal with readability while maintaining all original technical content. The single-file format ensures easy deployment.

