#!/bin/bash
lrank=$OMPI_COMM_WORLD_LOCAL_RANK
RANK=$OMPI_COMM_WORLD_RANK
WORLD_SIZE=$OMPI_COMM_WORLD_SIZE

CONFIG_DIR="examples/data2vec/config/v2"
# CONFIG_DIR="examples/data2vec/config/vision/finetuning"
CONFIG_NAME="base_images_only_task"
# CONFIG_NAME="mae_imagenet_clean"

DATA_PATH=`pwd`/"data"
CACHE_PATH=`pwd`/"scratch/cache_abaevski/imagenet"
CHECKPOINT_PATH=`pwd`/"checkpoints/checkpoint_last.pt"

APP="python3 fairseq_cli/hydra_train.py -m \
      task.data=$DATA_PATH \
      task.local_cache_path=$CACHE_PATH \
      distributed_training.distributed_init_method=tcp://${1}:34566  \
      distributed_training.device_id=$lrank \
      distributed_training.distributed_rank=$RANK \
      distributed_training.distributed_world_size=$WORLD_SIZE \
      distributed_training.distributed_no_spawn=True \
      --config-dir $CONFIG_DIR \
      --config-name $CONFIG_NAME \
    "


case ${lrank} in
[0])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_0:1
  export UCX_IB_PCI_BW=mlx5_0:50Gbs
  NCCL_SOCKET_IFNAME=ib0 numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_1:1
  export UCX_IB_PCI_BW=mlx5_1:50Gbs
  NCCL_SOCKET_IFNAME=ib0 numactl --cpunodebind=1 --membind=1 ${APP}
  ;;
[2])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_2:1
  export UCX_IB_PCI_BW=mlx5_2:50Gbs
  NCCL_SOCKET_IFNAME=ib0 numactl --cpunodebind=2 --membind=2 ${APP}
  ;;
[3])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_3:1
  export UCX_IB_PCI_BW=mlx5_3:50Gbs
  NCCL_SOCKET_IFNAME=ib0 numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
esac


