/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpufvPatch.H"

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::tmp<Foam::gpuField<Type>> Foam::gpufvPatch::patchInternalField
(
    const gpuList<Type>& f
) const
{
    tmp<gpuField<Type> > tpif(new gpuField<Type>(size()));
    gpuField<Type>& pif = tpif.ref();

    const labelgpuList& faceCells = this->gpuFaceCells();

    thrust::copy(thrust::make_permutation_iterator(f.begin(),faceCells.begin()),
                 thrust::make_permutation_iterator(f.begin(),faceCells.end()),
                 pif.begin());

    return tpif;
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>> Foam::gpufvPatch::patchInternalField
(
    const gpuList<Type>& f,
    const labelgpuList& faceCells
) const
{
    auto tpif = tmp<gpuField<Type>>::New(size());
    auto& pif = tpif.ref();

    thrust::copy(thrust::make_permutation_iterator(f.begin(),faceCells.begin()),
                 thrust::make_permutation_iterator(f.begin(),faceCells.end()),
                 pif.begin());

    return tpif;
}


template<class Type>
void Foam::gpufvPatch::patchInternalField
(
    const gpuList<Type>& f,
    gpuField<Type>& pif
) const
{
    pif.setSize(size());

    const labelgpuList& faceCells = this->gpuFaceCells();

    thrust::copy(thrust::make_permutation_iterator(f.begin(),faceCells.begin()),
                 thrust::make_permutation_iterator(f.begin(),faceCells.end()),
                 pif.begin());
}


template<class GeometricgpuField, class Type>
const typename GeometricgpuField::Patch& Foam::gpufvPatch::patchField
(
    const GeometricgpuField& gf
) const
{
    return gf.boundaryField()[index()];
}


// ************************************************************************* //
