/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2018 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "volgpuFields.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTemplate2TypeNameAndDebug(volScalargpuField::Internal, 0);
    defineTemplate2TypeNameAndDebug(volVectorgpuField::Internal, 0);
    defineTemplate2TypeNameAndDebug
    (
        volSphericalTensorgpuField::Internal,
        0
    );
    defineTemplate2TypeNameAndDebug
    (
        volSymmTensorgpuField::Internal,
        0
    );
    defineTemplate2TypeNameAndDebug(volTensorgpuField::Internal, 0);

    defineTemplateTypeNameAndDebug(volScalargpuField, 0);
    defineTemplateTypeNameAndDebug(volVectorgpuField, 0);
    defineTemplateTypeNameAndDebug(volSphericalTensorgpuField, 0);
    defineTemplateTypeNameAndDebug(volSymmTensorgpuField, 0);
    defineTemplateTypeNameAndDebug(volTensorgpuField, 0);

} // End namespace Foam


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

// Specializations

namespace Foam
{

template<>
tmp<GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>>
GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>::component
(
    const direction
) const
{
    return *this;
}


template<>
void GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>::replace
(
    const direction,
    const GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>& gsf
)
{
    *this == gsf;
}

} // End namespace Foam


// * * * * * * * * * * * * * * * * Global Data * * * * * * * * * * * * * * * //

// Note hard-coded values are more reliable than other alternatives

/*const Foam::wordList Foam::fieldTypes::internal
({
    "volScalargpuField::Internal",
    "volVectorgpuField::Internal",
    "volSphericalTensorgpuField::Internal",
    "volSymmTensorgpuField::Internal",
    "volTensorgpuField::Internal"
});


const Foam::wordList Foam::fieldTypes::volume
({
    "volScalargpuField",
    "volVectorgpuField",
    "volSphericalTensorgpuField",
    "volSymmTensorgpuField",
    "volTensorgpuField"
});
*/

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
