/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
    Copyright (C) 2017 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "IOobject.H"
#include "dictionary.H"
#include "gpufvMesh.H"
#include "gpusurfaceMesh.H"
#include "fvPatchgpuFieldMapper.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class Type>
Foam::fvsPatchgpuField<Type>::fvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    gpuField<Type>(p.size()),
    patch_(p),
    internalField_(iF)
{}


template<class Type>
Foam::fvsPatchgpuField<Type>::fvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const gpuField<Type>& f
)
:
    gpuField<Type>(f),
    patch_(p),
    internalField_(iF)
{}


template<class Type>
Foam::fvsPatchgpuField<Type>::fvsPatchgpuField
(
    const fvsPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    gpuField<Type>(ptf, mapper),
    patch_(p),
    internalField_(iF)
{}


template<class Type>
Foam::fvsPatchgpuField<Type>::fvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const dictionary& dict
)
:
    gpuField<Type>(p.size()),
    patch_(p),
    internalField_(iF)
{
    if (dict.found("value"))
    {
        fvsPatchgpuField<Type>::operator=
        (
            gpuField<Type>("value", dict, p.size())
        );
    }
    else
    {
        FatalIOErrorInFunction(dict)
            << "Essential entry 'value' missing on patch " << p.name() << nl
            << exit(FatalIOError);
    }
}


template<class Type>
Foam::fvsPatchgpuField<Type>::fvsPatchgpuField(const fvsPatchgpuField<Type>& ptf)
:
    gpuField<Type>(ptf),
    patch_(ptf.patch_),
    internalField_(ptf.internalField_)
{}


template<class Type>
Foam::fvsPatchgpuField<Type>::fvsPatchgpuField
(
    const fvsPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    gpuField<Type>(ptf),
    patch_(ptf.patch_),
    internalField_(iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
const Foam::objectRegistry& Foam::fvsPatchgpuField<Type>::db() const
{
    return patch_.boundaryMesh().mesh().hostmesh();
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::check(const fvsPatchgpuField<Type>& ptf) const
{
    if (&patch_ != &(ptf.patch_))
    {
        FatalErrorInFunction
            << "different patches for fvsPatchgpuField<Type>s"
            << abort(FatalError);
    }
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::autoMap(const fvPatchgpuFieldMapper& m)
{
/*
    const bool oriented = internalField_.oriented()();
    gpuField<Type>::autoMap(m, oriented);
*/
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::rmap
(
    const fvsPatchgpuField<Type>& ptf,
    const labelgpuList& addr
)
{
    gpuField<Type>::rmap(ptf, addr);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::write(Ostream& os) const
{
    os.writeEntry("type", type());
    this->writeEntry("value", os);
}


// * * * * * * * * * * * * * * * Member Operators  * * * * * * * * * * * * * //

template<class Type>
void Foam::fvsPatchgpuField<Type>::operator=
(
    const UList<Type>& ul
)
{
    gpuField<Type>::operator=(ul);
}

template<class Type>
void Foam::fvsPatchgpuField<Type>::operator=
(
    const gpuList<Type>& ul
)
{
    gpuField<Type>::operator=(ul);
}

template<class Type>
void Foam::fvsPatchgpuField<Type>::operator=
(
    const fvsPatchgpuField<Type>& ptf
)
{
    check(ptf);
    gpuField<Type>::operator=(ptf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator+=
(
    const fvsPatchgpuField<Type>& ptf
)
{
    check(ptf);
    gpuField<Type>::operator+=(ptf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator-=
(
    const fvsPatchgpuField<Type>& ptf
)
{
    check(ptf);
    gpuField<Type>::operator-=(ptf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator*=
(
    const fvsPatchgpuField<scalar>& ptf
)
{
    if (&patch_ != &ptf.patch())
    {
        FatalErrorInFunction
            << "incompatible patches for patch fields"
            << abort(FatalError);
    }

    gpuField<Type>::operator*=(ptf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator/=
(
    const fvsPatchgpuField<scalar>& ptf
)
{
    if (&patch_ != &ptf.patch())
    {
        FatalErrorInFunction
            << abort(FatalError);
    }

    gpuField<Type>::operator/=(ptf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator+=
(
    const gpuField<Type>& tf
)
{
    gpuField<Type>::operator+=(tf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator-=
(
    const gpuField<Type>& tf
)
{
    gpuField<Type>::operator-=(tf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator*=
(
    const scalargpuField& tf
)
{
    gpuField<Type>::operator*=(tf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator/=
(
    const scalargpuField& tf
)
{
    gpuField<Type>::operator/=(tf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator=
(
    const Type& t
)
{
    gpuField<Type>::operator=(t);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator+=
(
    const Type& t
)
{
    gpuField<Type>::operator+=(t);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator-=
(
    const Type& t
)
{
    gpuField<Type>::operator-=(t);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator*=
(
    const scalar s
)
{
    gpuField<Type>::operator*=(s);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator/=
(
    const scalar s
)
{
    gpuField<Type>::operator/=(s);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator==
(
    const fvsPatchgpuField<Type>& ptf
)
{
    gpuField<Type>::operator=(ptf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator==
(
    const gpuField<Type>& tf
)
{
    gpuField<Type>::operator=(tf);
}


template<class Type>
void Foam::fvsPatchgpuField<Type>::operator==
(
    const Type& t
)
{
    gpuField<Type>::operator=(t);
}


// * * * * * * * * * * * * * * * IOstream Operators  * * * * * * * * * * * * //

template<class Type>
Foam::Ostream& Foam::operator<<(Ostream& os, const fvsPatchgpuField<Type>& ptf)
{
    ptf.write(os);

    os.check(FUNCTION_NAME);

    return os;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "fvsPatchgpuFieldNew.C"

// ************************************************************************* //
