/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "slicedFvsPatchgpuField.H"

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::slicedFvsPatchgpuField<Type>::slicedFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const gpuField<Type>& completeField
)
:
    fvsPatchgpuField<Type>(p, iF, gpuField<Type>())
{
    // Set the fvsPatchgpuField to a slice of the given complete field
    gpuList<Type>::operator=(gpuList<Type>(completeField,p.size(),p.start()));
}


template<class Type>
Foam::slicedFvsPatchgpuField<Type>::slicedFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::slicedFvsPatchgpuField<Type>::slicedFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const dictionary& dict
)
:
    fvsPatchgpuField<Type>(p, iF, gpuField<Type>("value", dict, p.size()))
{
    NotImplemented;
}


template<class Type>
Foam::slicedFvsPatchgpuField<Type>::slicedFvsPatchgpuField
(
    const slicedFvsPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fvsPatchgpuField<Type>(ptf, p, iF, mapper)
{
    NotImplemented;
}


template<class Type>
Foam::slicedFvsPatchgpuField<Type>::slicedFvsPatchgpuField
(
    const slicedFvsPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(ptf.patch(), iF, gpuField<Type>())
{
    // Transfer the slice from the argument
    gpuList<Type>::operator=(ptf);
}


template<class Type>
Foam::tmp<Foam::fvsPatchgpuField<Type>>
Foam::slicedFvsPatchgpuField<Type>::clone() const
{
    return tmp<fvsPatchgpuField<Type>>
    (
        new slicedFvsPatchgpuField<Type>(*this)
    );
}


template<class Type>
Foam::slicedFvsPatchgpuField<Type>::slicedFvsPatchgpuField
(
    const slicedFvsPatchgpuField<Type>& ptf
)
:
    fvsPatchgpuField<Type>
    (
        ptf.patch(),
        ptf.internalField(),
        gpuField<Type>()
    )
{
    // Transfer the slice from the argument
    gpuList<Type>::operator=(ptf);
}


template<class Type>
Foam::tmp<Foam::fvsPatchgpuField<Type>>
Foam::slicedFvsPatchgpuField<Type>::clone
(
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
) const
{
    return tmp<fvsPatchgpuField<Type>>
    (
        new slicedFvsPatchgpuField<Type>(*this, iF)
    );
}


template<class Type>
Foam::slicedFvsPatchgpuField<Type>::~slicedFvsPatchgpuField()
{
    // Set the fvsPatchgpuField storage pointer to nullptr before its destruction
    // to protect the field it a slice of.
    gpuList<Type>::clear();
}


// ************************************************************************* //
