/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "fixedValueFvsPatchgpuField.H"

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::fixedValueFvsPatchgpuField<Type>::fixedValueFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::fixedValueFvsPatchgpuField<Type>::fixedValueFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const dictionary& dict
)
:
    fvsPatchgpuField<Type>(p, iF, gpuField<Type>("value", dict, p.size()))
{}


template<class Type>
Foam::fixedValueFvsPatchgpuField<Type>::fixedValueFvsPatchgpuField
(
    const fixedValueFvsPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fvsPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::fixedValueFvsPatchgpuField<Type>::fixedValueFvsPatchgpuField
(
    const fixedValueFvsPatchgpuField<Type>& ptf
)
:
    fvsPatchgpuField<Type>(ptf)
{}


template<class Type>
Foam::fixedValueFvsPatchgpuField<Type>::fixedValueFvsPatchgpuField
(
    const fixedValueFvsPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(ptf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::fixedValueFvsPatchgpuField<Type>::valueInternalCoeffs
(
    const tmp<scalargpuField>&
) const
{
    return tmp<gpuField<Type>>
    (
        new gpuField<Type>(this->size(), Zero)
    );
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::fixedValueFvsPatchgpuField<Type>::valueBoundaryCoeffs
(
    const tmp<scalargpuField>&
) const
{
    return *this;
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::fixedValueFvsPatchgpuField<Type>::gradientInternalCoeffs() const
{
    return -pTraits<Type>::one*this->patch().deltaCoeffs();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::fixedValueFvsPatchgpuField<Type>::gradientBoundaryCoeffs() const
{
    return this->patch().deltaCoeffs()*(*this);
}


// ************************************************************************* //
