/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "calculatedFvsPatchgpuField.H"
#include "fvPatchgpuFieldMapper.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
const Foam::word& Foam::fvsPatchgpuField<Type>::calculatedType()
{
    return calculatedFvsPatchgpuField<Type>::typeName;
}

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class Type>
Foam::calculatedFvsPatchgpuField<Type>::calculatedFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::calculatedFvsPatchgpuField<Type>::calculatedFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const dictionary& dict
)
:
    fvsPatchgpuField<Type>(p, iF, gpuField<Type>("value", dict, p.size()))
{}


template<class Type>
Foam::calculatedFvsPatchgpuField<Type>::calculatedFvsPatchgpuField
(
    const calculatedFvsPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fvsPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::calculatedFvsPatchgpuField<Type>::calculatedFvsPatchgpuField
(
    const calculatedFvsPatchgpuField<Type>& ptf
)
:
    fvsPatchgpuField<Type>(ptf)
{}


template<class Type>
Foam::calculatedFvsPatchgpuField<Type>::calculatedFvsPatchgpuField
(
    const calculatedFvsPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(ptf, iF)
{}


template<class Type>
Foam::tmp<Foam::fvsPatchgpuField<Type>>
Foam::fvsPatchgpuField<Type>::NewCalculatedType
(
    const gpufvPatch& p
)
{
    auto* patchTypeCtor = patchConstructorTable(p.type());

    if (patchTypeCtor)
    {
        return patchTypeCtor
        (
            p,
            DimensionedgpuField<Type, gpusurfaceMesh>::null()
        );
    }
    else
    {
        return tmp<fvsPatchgpuField<Type>>
        (
            new calculatedFvsPatchgpuField<Type>
            (
                p,
                DimensionedgpuField<Type, gpusurfaceMesh>::null()
            )
        );
    }
}


template<class Type>
template<class Type2>
Foam::tmp<Foam::fvsPatchgpuField<Type>>
Foam::fvsPatchgpuField<Type>::NewCalculatedType
(
    const fvsPatchgpuField<Type2>& pf
)
{
    return NewCalculatedType(pf.patch());
}


// ************************************************************************* //
