/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "transformFvPatchgpuField.H"
#include "IOstreams.H"
#include "transformField.H"

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::transformFvPatchgpuField<Type>::transformFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
   fvPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::transformFvPatchgpuField<Type>::transformFvPatchgpuField
(
    const transformFvPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fvPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::transformFvPatchgpuField<Type>::transformFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fvPatchgpuField<Type>(p, iF, dict, false)
{}


template<class Type>
Foam::transformFvPatchgpuField<Type>::transformFvPatchgpuField
(
    const transformFvPatchgpuField<Type>& ptf
)
:
    fvPatchgpuField<Type>(ptf)
{}


template<class Type>
Foam::transformFvPatchgpuField<Type>::transformFvPatchgpuField
(
    const transformFvPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    fvPatchgpuField<Type>(ptf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::transformFvPatchgpuField<Type>::valueInternalCoeffs
(
    const tmp<scalargpuField>&
) const
{
    return pTraits<Type>::one - snGradTransformDiag();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::transformFvPatchgpuField<Type>::valueBoundaryCoeffs
(
    const tmp<scalargpuField>&
) const
{
    return
        *this
      - cmptMultiply
        (
            valueInternalCoeffs(this->patch().weights()),
            this->patchInternalField()
        );
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::transformFvPatchgpuField<Type>::gradientInternalCoeffs() const
{
    return -this->patch().deltaCoeffs()*snGradTransformDiag();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::transformFvPatchgpuField<Type>::gradientBoundaryCoeffs() const
{
    return
        snGrad()
      - cmptMultiply(gradientInternalCoeffs(), this->patchInternalField());
}


// * * * * * * * * * * * * * * * Member Operators  * * * * * * * * * * * * * //

template<class Type>
void Foam::transformFvPatchgpuField<Type>::operator=
(
    const fvPatchgpuField<Type>& ptf
)
{
    this->evaluate();
}


// ************************************************************************* //
