/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpufvcLaplacian.H"
#include "gpufvMesh.H"
#include "gpulaplacianScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fvc
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    return fv::gpulaplacianScheme<Type, scalar>::New
    (
        vf.mesh(),
        vf.mesh().hostmesh().laplacianScheme(name)
    ).ref().fvcLaplacian(vf);
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(tvf(), name)
    );
    tvf.clear();
    return Laplacian;
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fvc::laplacian(vf, "laplacian(" + vf.name() + ')');
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(tvf())
    );
    tvf.clear();
    return Laplacian;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const dimensioned<GType>& gamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh> Gamma
    (
        IOobject
        (
            gamma.name(),
            vf.instance(),
            vf.mesh().hostmesh(),
            IOobject::NO_READ
        ),
        vf.mesh(),
        gamma
    );

    return fvc::laplacian(Gamma, vf, name);
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const dimensioned<GType>& gamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(gamma, tvf(), name)
    );
    tvf.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const dimensioned<GType>& gamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh> Gamma
    (
        IOobject
        (
            gamma.name(),
            vf.instance(),
            vf.mesh().hostmesh(),
            IOobject::NO_READ
        ),
        vf.mesh(),
        gamma
    );

    return fvc::laplacian(Gamma, vf);
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const dimensioned<GType>& gamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(gamma, tvf())
    );
    tvf.clear();
    return Laplacian;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>& gamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    return fv::gpulaplacianScheme<Type, GType>::New
    (
        vf.mesh(),
        vf.mesh().hostmesh().laplacianScheme(name)
    ).ref().fvcLaplacian(gamma, vf);
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>& tgamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(tgamma(), vf, name)
    );
    tgamma.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>& gamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(gamma, tvf(), name)
    );
    tvf.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>& tgamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(tgamma(), tvf(), name)
    );
    tgamma.clear();
    tvf.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>& gamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fvc::laplacian
    (
        gamma,
        vf,
        "laplacian(" + gamma.name() + ',' + vf.name() + ')'
    );
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>& tgamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fvc::laplacian
    (
        tgamma,
        vf,
        "laplacian(" + tgamma().name() + ',' + vf.name() + ')'
    );
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>& gamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    return fvc::laplacian
    (
        gamma,
        tvf,
        "laplacian(" + gamma.name() + ',' + tvf().name() + ')'
    );
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>& tgamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    return fvc::laplacian
    (
        tgamma,
        tvf,
        "laplacian(" + tgamma().name() + ',' + tvf().name() + ')'
    );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>& gamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    return fv::gpulaplacianScheme<Type, GType>::New
    (
        vf.mesh(),
        vf.mesh().hostmesh().laplacianScheme(name)
    ).ref().fvcLaplacian(gamma, vf);
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>& tgamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(tgamma(), vf, name)
    );
    tgamma.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>& gamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(gamma, tvf(), name)
    );
    tvf.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
(
    const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>& tgamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(tgamma(), tvf(), name)
    );
    tgamma.clear();
    tvf.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>& gamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fvc::laplacian
    (
        gamma,
        vf,
        "laplacian(" + gamma.name() + ',' + vf.name() + ')'
    );
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>& tgamma,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(tgamma(), vf)
    );
    tgamma.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
laplacian
(
    const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>& gamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(gamma, tvf())
    );
    tvf.clear();
    return Laplacian;
}


template<class Type, class GType>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> laplacian
(
    const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>& tgamma,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Laplacian
    (
        fvc::laplacian(tgamma(), tvf())
    );
    tgamma.clear();
    tvf.clear();
    return Laplacian;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fvc

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
