/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2016 OpenFOAM Foundation
    Copyright (C) 2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpuconstrainPressure.H"
#include "volgpuFields.H"
#include "surfacegpuFields.H"
#include "geometricOneField.H"
#include "updateableSnGrad.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class RhoType, class RAUType, class MRFType>
void Foam::constrainPressure
(
    volScalargpuField& p,
    const RhoType& rho,
    const volVectorgpuField& U,
    const surfaceScalargpuField& phiHbyA,
    const RAUType& rhorAU,
    const MRFType& MRF
)
{
    const gpufvMesh& mesh = p.mesh();

    volScalargpuField::Boundary& pBf = p.boundaryFieldRef();

    const volVectorgpuField::Boundary& UBf = U.boundaryField();
    const surfaceScalargpuField::Boundary& phiHbyABf =
        phiHbyA.boundaryField();
    const typename RAUType::Boundary& rhorAUBf = rhorAU.boundaryField();
    const surfaceVectorgpuField::Boundary& SfBf = mesh.Sf().boundaryField();
    const surfaceScalargpuField::Boundary& magSfBf =
        mesh.magSf().boundaryField();

    forAll(pBf, patchi)
    {
        typedef updateablePatchTypes::updateableSnGrad snGradType;
        const auto* snGradPtr = isA<snGradType>(pBf[patchi]);

        if (snGradPtr)
        {
Info<<"---------暂时注释掉了"<<endl;
            /*const_cast<snGradType&>(*snGradPtr).updateSnGrad
            (
                (
                    phiHbyABf[patchi]
                  - rho.boundaryField()[patchi]
                   *MRF.relative(SfBf[patchi] & UBf[patchi], patchi)
                )
               /(magSfBf[patchi]*rhorAUBf[patchi])
            );*/
        }
    }
}


template<class RAUType>
void Foam::constrainPressure
(
    volScalargpuField& p,
    const volScalargpuField& rho,
    const volVectorgpuField& U,
    const surfaceScalargpuField& phiHbyA,
    const RAUType& rAU
)
{
    constrainPressure(p, rho, U, phiHbyA, rAU, gpuNullMRF());
}


template<class RAUType, class MRFType>
void Foam::constrainPressure
(
    volScalargpuField& p,
    const volVectorgpuField& U,
    const surfaceScalargpuField& phiHbyA,
    const RAUType& rAU,
    const MRFType& MRF
)
{
    constrainPressure(p, geometricOneField(), U, phiHbyA, rAU, MRF);
}


template<class RAUType>
void Foam::constrainPressure
(
    volScalargpuField& p,
    const volVectorgpuField& U,
    const surfaceScalargpuField& phiHbyA,
    const RAUType& rAU
)
{
    constrainPressure(p, U, phiHbyA, rAU, gpuNullMRF());
}


// ************************************************************************* //
