/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2013 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::blendedSchemeBase

Description
    Base class for blended schemes to provide access to the blending factor
    surface field

\*---------------------------------------------------------------------------*/

#ifndef gpublendedSchemeBase_H
#define gpublendedSchemeBase_H

#include "className.H"
#include "tmp.H"
#include "surfacegpuFieldsFwd.H"
#include "volgpuFieldsFwd.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

TemplateName(gpublendedSchemeBase);

/*---------------------------------------------------------------------------*\
                      Class blendedSchemeBase Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class gpublendedSchemeBase
:
    public gpublendedSchemeBaseName
{

public:

    //- Constructor
    gpublendedSchemeBase()
    {}

    //- Destructor
    virtual ~gpublendedSchemeBase() = default;


    // Member Functions

        //- Return the face-based blending factor
        virtual tmp<surfaceScalargpuField> blendingFactor
        (
             const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
        ) const = 0;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
