/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "emptyFvsPatchgpuField.H"
#include "fvPatchgpuFieldMapper.H"
#include "gpusurfaceMesh.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class Type>
Foam::emptyFvsPatchgpuField<Type>::emptyFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(p, iF, gpuField<Type>(0))
{}


template<class Type>
Foam::emptyFvsPatchgpuField<Type>::emptyFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const dictionary& dict
)
:
    fvsPatchgpuField<Type>(p, iF, gpuField<Type>(0))
{
    if (!isType<emptygpuFvPatch>(p))
    {
        FatalIOErrorInFunction(dict)
            << "patch " << this->patch().index() << " not empty type. "
            << "Patch type = " << p.type()
            << exit(FatalIOError);
    }
}


template<class Type>
Foam::emptyFvsPatchgpuField<Type>::emptyFvsPatchgpuField
(
    const emptyFvsPatchgpuField<Type>&,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const fvPatchgpuFieldMapper&
)
:
    fvsPatchgpuField<Type>(p, iF, gpuField<Type>(0))
{
    if (!isType<emptygpuFvPatch>(this->patch()))
    {
        FatalErrorInFunction
            << "Field type does not correspond to patch type for patch "
            << this->patch().index() << "." << endl
            << "Field type: " << typeName << endl
            << "Patch type: " << this->patch().type()
            << exit(FatalError);
    }
}


template<class Type>
Foam::emptyFvsPatchgpuField<Type>::emptyFvsPatchgpuField
(
    const emptyFvsPatchgpuField<Type>& ptf
)
:
    fvsPatchgpuField<Type>
    (
        ptf.patch(),
        ptf.internalField(),
        gpuField<Type>(0)
    )
{}


template<class Type>
Foam::emptyFvsPatchgpuField<Type>::emptyFvsPatchgpuField
(
    const emptyFvsPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(ptf.patch(), iF, gpuField<Type>(0))
{}


// ************************************************************************* //
