/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::slicedFvsPatchgpuField

Description
    Specialization of fvsPatchgpuField which creates the underlying
    fvsPatchgpuField as a slice of the given complete field.

    The destructor is wrapped to avoid deallocation of the storage of the
    complete fields when this is destroyed.

    Should only used as a template argument for SlicedGeometricField.

SourceFiles
    slicedFvsPatchgpuField.C

\*---------------------------------------------------------------------------*/

#ifndef slicedFvsPatchgpuField_H
#define slicedFvsPatchgpuField_H

#include "fvsPatchgpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                           Class slicedFvsPatch Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class slicedFvsPatchgpuField
:
    public fvsPatchgpuField<Type>
{

public:

    //- Runtime type information
    TypeName("sliced");


    // Constructors

        //- Construct from patch, internal field and field to slice
        slicedFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const gpuField<Type>&
        );

        //- Construct from patch and internal field
        slicedFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct from patch, internal field and dictionary
        slicedFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const dictionary&
        );

        //- Construct by mapping the given slicedFvsPatchgpuField<Type>
        //  onto a new patch
        slicedFvsPatchgpuField
        (
            const slicedFvsPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        slicedFvsPatchgpuField(const slicedFvsPatchgpuField<Type>&);

        //- Construct and return a clone
        virtual tmp<fvsPatchgpuField<Type>> clone() const;

        //- Construct as copy setting internal field reference
        slicedFvsPatchgpuField
        (
            const slicedFvsPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvsPatchgpuField<Type>> clone
        (
            const DimensionedgpuField<Type, gpusurfaceMesh>& iF
        ) const;


    //- Destructor
    virtual ~slicedFvsPatchgpuField<Type>();


    // Member functions

        // Access

            //- Return true if this patch field fixes a value.
            //  Needed to check if a level has to be specified while solving
            //  Poissons equations.
            virtual bool fixesValue() const
            {
                return true;
            }


    // Member operators

        virtual void operator=(const UList<Type>&) {}
        virtual void operator=(const gpuList<Type>&) {}

        virtual void operator=(const fvsPatchgpuField<Type>&) {}
        virtual void operator+=(const fvsPatchgpuField<Type>&) {}
        virtual void operator-=(const fvsPatchgpuField<Type>&) {}
        virtual void operator*=(const fvsPatchgpuField<scalar>&) {}
        virtual void operator/=(const fvsPatchgpuField<scalar>&) {}

        virtual void operator+=(const gpuField<Type>&) {}
        virtual void operator-=(const gpuField<Type>&) {}

        virtual void operator*=(const gpuField<scalar>&) {}
        virtual void operator/=(const gpuField<scalar>&) {}

        virtual void operator=(const Type&) {}
        virtual void operator+=(const Type&) {}
        virtual void operator-=(const Type&) {}
        virtual void operator*=(const scalar) {}
        virtual void operator/=(const scalar) {}
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "slicedFvsPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
