/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "movingWallVelocityFvPatchVectorgpuField.H"
#include "volgpuFields.H"
#include "surfacegpuFields.H"
#include "gpufvcMeshPhi.H"
#include "addToRunTimeSelectionTable.H"
#include "faceFunctors.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::movingWallVelocityFvPatchVectorgpuField::
movingWallVelocityFvPatchVectorgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<vector, gpuvolMesh>& iF
)
:
    fixedValueFvPatchVectorgpuField(p, iF)
{}


Foam::movingWallVelocityFvPatchVectorgpuField::
movingWallVelocityFvPatchVectorgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<vector, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedValueFvPatchVectorgpuField(p, iF, dict)
{}


Foam::movingWallVelocityFvPatchVectorgpuField::
movingWallVelocityFvPatchVectorgpuField
(
    const movingWallVelocityFvPatchVectorgpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<vector, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedValueFvPatchVectorgpuField(ptf, p, iF, mapper)
{}


Foam::movingWallVelocityFvPatchVectorgpuField::
movingWallVelocityFvPatchVectorgpuField
(
    const movingWallVelocityFvPatchVectorgpuField& mwvpvf
)
:
    fixedValueFvPatchVectorgpuField(mwvpvf)
{}


Foam::movingWallVelocityFvPatchVectorgpuField::
movingWallVelocityFvPatchVectorgpuField
(
    const movingWallVelocityFvPatchVectorgpuField& mwvpvf,
    const DimensionedgpuField<vector, gpuvolMesh>& iF
)
:
    fixedValueFvPatchVectorgpuField(mwvpvf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::tmp<Foam::vectorgpuField>
Foam::movingWallVelocityFvPatchVectorgpuField::Uwall() const
{
    const fvMesh& mesh = internalField().mesh().hostmesh();
    const gpufvPatch& p = patch();
    const polyPatch& pp = p.patch();
    //const pointgpuField& oldPoints = mesh.gpuoldPoints();
    const pointgpuField oldPoints(mesh.oldPoints());

    const faceDatagpuList &faces = pp.gpuFaces();
    const labelgpuList &faceNodes = pp.gpuFaceNodes();

    vectorgpuField oldFc(pp.size());

    //forAll(oldFc, i)
    //{
    //    oldFc[i] = pp[i].centre(oldPoints);
    //}

    thrust::transform
    (
        faces.begin(),
        faces.end(),
        oldFc.begin(),
        faceCentreFunctor
        (
            faceNodes.data(),
            oldPoints.data()
        )   
    );

    const scalar deltaT = mesh.time().deltaTValue();

    const vectorgpuField Up((pp.gpuFaceCentres() - oldFc)/deltaT);

    const volVectorgpuField& U =
        static_cast<const volVectorgpuField&>(internalField());

    scalargpuField phip
    (
        p.patchField<surfaceScalargpuField, scalar>(fvc::meshPhi(U))
    );

    const vectorgpuField n(p.nf());
    const scalargpuField& magSf = p.magSf();
    tmp<scalargpuField> Un = phip/(magSf + VSMALL);

    return (Up + n*(Un - (n & Up)));
}


void Foam::movingWallVelocityFvPatchVectorgpuField::updateCoeffs()
{
    if (updated())
    {
        return;
    }

    const fvMesh& mesh = internalField().mesh().hostmesh();

    if (mesh.moving())
    {
        const vectorgpuField uwall(Uwall());
        vectorgpuField::operator=(uwall);
    }

    fixedValueFvPatchVectorgpuField::updateCoeffs();
}


void Foam::movingWallVelocityFvPatchVectorgpuField::write(Ostream& os) const
{
    fvPatchVectorgpuField::write(os);
    writeEntry("value", os);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    makePatchTypeField
    (
        fvPatchVectorgpuField,
        movingWallVelocityFvPatchVectorgpuField
    );
}

// ************************************************************************* //
