/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
    Copyright (C) 2020 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::polyBoundaryMeshEntries

Description
    Read and store dictionary entries for boundary patches

SourceFiles
    polyBoundaryMeshEntries.C

\*---------------------------------------------------------------------------*/

#ifndef polyBoundaryMeshEntries_H
#define polyBoundaryMeshEntries_H

#include "regIOobject.H"
#include "PtrList.H"
#include "entry.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                   Class polyBoundaryMeshEntries Declaration
\*---------------------------------------------------------------------------*/

class polyBoundaryMeshEntries
:
    public regIOobject,
    public PtrList<entry>
{
public:

    //- Runtime type information
    TypeNameNoDebug("polyBoundaryMesh");


    // Constructors

        explicit polyBoundaryMeshEntries(const IOobject& io)
        :
            regIOobject(io),
            PtrList<entry>()
        {
            if
            (
                (
                    io.readOpt() == IOobject::MUST_READ
                 || io.readOpt() == IOobject::MUST_READ_IF_MODIFIED
                )
             || (io.readOpt() == IOobject::READ_IF_PRESENT && headerOk())
            )
            {
                readStream(typeName) >> *this;
            }
        }


   // Member Functions

        bool writeData(Ostream&) const
        {
            NotImplemented;
            return false;
        }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
