/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2013 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::alphaFixedPressureFvPatchScalarField

Description
    A fixed-pressure alphaContactAngle boundary

SourceFiles
    alphaFixedPressureFvPatchScalarField.C

\*---------------------------------------------------------------------------*/

#ifndef alphaFixedPressureFvPatchScalargpuField_H
#define alphaFixedPressureFvPatchScalargpuField_H

#include "fixedValueFvPatchgpuFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                 Class alphaFixedPressureFvPatch Declaration
\*---------------------------------------------------------------------------*/

class alphaFixedPressureFvPatchScalargpuField
:
    public fixedValueFvPatchScalargpuField
{
    // Private data

        //- Fixed pressure
        scalargpuField p_;


public:

    //- Runtime type information
    TypeName("alphaFixedPressure");


    // Constructors

        //- Construct from patch and internal field
        alphaFixedPressureFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        alphaFixedPressureFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given alphaFixedPressureFvPatchScalarField
        //  onto a new patch
        alphaFixedPressureFvPatchScalargpuField
        (
            const alphaFixedPressureFvPatchScalargpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        alphaFixedPressureFvPatchScalargpuField
        (
            const alphaFixedPressureFvPatchScalargpuField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchScalargpuField> clone() const
        {
            return tmp<fvPatchScalargpuField>
            (
                new alphaFixedPressureFvPatchScalargpuField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        alphaFixedPressureFvPatchScalargpuField
        (
            const alphaFixedPressureFvPatchScalargpuField&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchScalargpuField> clone
        (
            const DimensionedgpuField<scalar, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchScalargpuField>
            (
                new alphaFixedPressureFvPatchScalargpuField(*this, iF)
            );
        }


    // Member functions

        // Access

            //- Return the alphaFixed pressure
            const scalargpuField& p() const
            {
                return p_;
            }

            //- Return reference to the alphaFixed pressure to allow adjustment
            scalargpuField& p()
            {
                return p_;
            }


        // Mapping functions

            //- Map (and resize as needed) from self given a mapping object
            virtual void autoMap
            (
                const fvPatchgpuFieldMapper&
            );

            //- Reverse map the given fvPatchField onto this fvPatchField
            virtual void rmap
            (
                const fvPatchScalargpuField&,
                const labelgpuList&
            );


        // Evaluation functions

            //- Update the coefficients associated with the patch field
            virtual void updateCoeffs();


        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
