/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2018 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "alphaFixedPressureFvPatchScalargpuField.H"
#include "addToRunTimeSelectionTable.H"
#include "fvPatchgpuFieldMapper.H"
#include "volgpuFields.H"
#include "surfacegpuFields.H"
#include "gravityMeshObject.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::alphaFixedPressureFvPatchScalargpuField::
alphaFixedPressureFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedValueFvPatchScalargpuField(p, iF),
    p_(p.size(), Zero)
{}


Foam::alphaFixedPressureFvPatchScalargpuField::
alphaFixedPressureFvPatchScalargpuField
(
    const alphaFixedPressureFvPatchScalargpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedValueFvPatchScalargpuField(ptf, p, iF, mapper),
    p_(ptf.p_, mapper)
{}


Foam::alphaFixedPressureFvPatchScalargpuField::
alphaFixedPressureFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedValueFvPatchScalargpuField(p, iF, dict, false),
    p_("p", dict, p.size())
{
    if (dict.found("value"))
    {
        fvPatchgpuField<scalar>::operator=
        (
            scalargpuField("value", dict, p.size())
        );
    }
    else
    {
        fvPatchgpuField<scalar>::operator=(p_);
    }
}


Foam::alphaFixedPressureFvPatchScalargpuField::
alphaFixedPressureFvPatchScalargpuField
(
    const alphaFixedPressureFvPatchScalargpuField& tppsf
)
:
    fixedValueFvPatchScalargpuField(tppsf),
    p_(tppsf.p_)
{}


Foam::alphaFixedPressureFvPatchScalargpuField::
alphaFixedPressureFvPatchScalargpuField
(
    const alphaFixedPressureFvPatchScalargpuField& tppsf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedValueFvPatchScalargpuField(tppsf, iF),
    p_(tppsf.p_)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::alphaFixedPressureFvPatchScalargpuField::autoMap
(
    const fvPatchgpuFieldMapper& m
)
{
    scalargpuField::autoMap(m);
    p_.autoMap(m);
}


void Foam::alphaFixedPressureFvPatchScalargpuField::rmap
(
    const fvPatchScalargpuField& ptf,
    const labelgpuList& addr
)
{
    fixedValueFvPatchScalargpuField::rmap(ptf, addr);

    const alphaFixedPressureFvPatchScalargpuField& tiptf =
        refCast<const alphaFixedPressureFvPatchScalargpuField>(ptf);

    p_.rmap(tiptf.p_, addr);
}


void Foam::alphaFixedPressureFvPatchScalargpuField::updateCoeffs()
{
    if (updated())
    {
        return;
    }

    const uniformDimensionedVectorField& g =
        meshObjects::gravity::New(db().time());

    const fvPatchgpuField<scalar>& rho =
        patch().lookupPatchField<volScalargpuField, scalar>("rho");

    operator==(p_ - rho*(g.value() & patch().Cf()));

    fixedValueFvPatchScalargpuField::updateCoeffs();
}


void Foam::alphaFixedPressureFvPatchScalargpuField::write
(
    Ostream& os
) const
{
    fvPatchScalargpuField::write(os);
    p_.writeEntry("p", os);
    writeEntry("value", os);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    makePatchTypeField
    (
        fvPatchScalargpuField,
        alphaFixedPressureFvPatchScalargpuField
    );
}

// ************************************************************************* //
