/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2015-2016 OpenFOAM Foundation
    Copyright (C) 2019-2020 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "temperatureDependentAlphaContactAngleFvPatchScalargpuField.H"
#include "fvPatchgpuFieldMapper.H"
#include "volgpuFields.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::temperatureDependentAlphaContactAngleFvPatchScalargpuField::
temperatureDependentAlphaContactAngleFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(p, iF),
    TName_("T"),
    theta0_()
{}


Foam::temperatureDependentAlphaContactAngleFvPatchScalargpuField::
temperatureDependentAlphaContactAngleFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(p, iF, dict),
    TName_(dict.getOrDefault<word>("T", "T")),
    theta0_(Function1<scalar>::New("theta0", dict, &db()))
{
    evaluate();
}


Foam::temperatureDependentAlphaContactAngleFvPatchScalargpuField::
temperatureDependentAlphaContactAngleFvPatchScalargpuField
(
    const temperatureDependentAlphaContactAngleFvPatchScalargpuField& psf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(psf, p, iF, mapper),
    TName_(psf.TName_),
    theta0_(psf.theta0_.clone())
{}


Foam::temperatureDependentAlphaContactAngleFvPatchScalargpuField::
temperatureDependentAlphaContactAngleFvPatchScalargpuField
(
    const temperatureDependentAlphaContactAngleFvPatchScalargpuField& psf
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(psf),
    TName_(psf.TName_),
    theta0_(psf.theta0_.clone())
{}


Foam::temperatureDependentAlphaContactAngleFvPatchScalargpuField::
temperatureDependentAlphaContactAngleFvPatchScalargpuField
(
    const temperatureDependentAlphaContactAngleFvPatchScalargpuField& psf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(psf, iF),
    TName_(psf.TName_),
    theta0_(psf.theta0_.clone())
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::tmp<Foam::scalargpuField>
Foam::temperatureDependentAlphaContactAngleFvPatchScalargpuField::theta
(
    const fvPatchVectorgpuField&,
    const fvsPatchVectorgpuField&
) const
{
    return theta0_->value
    (
        patch().lookupPatchField<volScalargpuField, scalar>(TName_)
    );
}


void Foam::temperatureDependentAlphaContactAngleFvPatchScalargpuField::write
(
    Ostream& os
) const
{
    alphaContactAngleTwoPhaseFvPatchScalargpuField::write(os);
    os.writeEntryIfDifferent<word>("T", "T", TName_);
    theta0_->writeData(os);
    writeEntry("value", os);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    makePatchTypeField
    (
        fvPatchScalargpuField,
        temperatureDependentAlphaContactAngleFvPatchScalargpuField
    );
}

// ************************************************************************* //
