/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::constantAlphaContactAngleFvPatchScalarField

Description
    A constant alphaContactAngle scalar boundary condition.

See also
    Foam::alphaContactAngleTwoPhaseFvPatchScalarField
    Foam::temperatureDependentAlphaContactAngleFvPatchScalarField

SourceFiles
    constantAlphaContactAngleFvPatchScalarField.C

\*---------------------------------------------------------------------------*/

#ifndef constantAlphaContactAngleFvPatchScalargpuField_H
#define constantAlphaContactAngleFvPatchScalargpuField_H

#include "alphaContactAngleTwoPhaseFvPatchScalargpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
              Class constantAlphaContactAngleFvPatch Declaration
\*---------------------------------------------------------------------------*/

class constantAlphaContactAngleFvPatchScalargpuField
:
    public alphaContactAngleTwoPhaseFvPatchScalargpuField
{
    // Private data

        //- Equilibrium contact angle
        scalar theta0_;


public:

    //- Runtime type information
    TypeName("constantAlphaContactAngle");


    // Constructors

        //- Construct from patch and internal field
        constantAlphaContactAngleFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        constantAlphaContactAngleFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given
        //  constantAlphaContactAngleFvPatchScalarField
        //  onto a new patch
        constantAlphaContactAngleFvPatchScalargpuField
        (
            const constantAlphaContactAngleFvPatchScalargpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        constantAlphaContactAngleFvPatchScalargpuField
        (
            const constantAlphaContactAngleFvPatchScalargpuField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchScalargpuField> clone() const
        {
            return tmp<fvPatchScalargpuField>
            (
                new constantAlphaContactAngleFvPatchScalargpuField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        constantAlphaContactAngleFvPatchScalargpuField
        (
            const constantAlphaContactAngleFvPatchScalargpuField&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchScalargpuField> clone
        (
            const DimensionedgpuField<scalar, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchScalargpuField>
            (
                new constantAlphaContactAngleFvPatchScalargpuField(*this, iF)
            );
        }


    // Member functions

        //- Return the equilibrium contact-angle
        virtual tmp<scalargpuField> theta
        (
            const fvPatchVectorgpuField& Up,
            const fvsPatchVectorgpuField& nHat
        ) const;

        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
