/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "constantAlphaContactAngleFvPatchScalargpuField.H"
#include "gpuvolMesh.H"
#include "fvPatchgpuFieldMapper.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::constantAlphaContactAngleFvPatchScalargpuField::
constantAlphaContactAngleFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(p, iF),
    theta0_(0.0)
{}


Foam::constantAlphaContactAngleFvPatchScalargpuField::
constantAlphaContactAngleFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(p, iF, dict),
    theta0_(dict.get<scalar>("theta0"))
{
    evaluate();
}


Foam::constantAlphaContactAngleFvPatchScalargpuField::
constantAlphaContactAngleFvPatchScalargpuField
(
    const constantAlphaContactAngleFvPatchScalargpuField& gcpsf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(gcpsf, p, iF, mapper),
    theta0_(gcpsf.theta0_)
{}


Foam::constantAlphaContactAngleFvPatchScalargpuField::
constantAlphaContactAngleFvPatchScalargpuField
(
    const constantAlphaContactAngleFvPatchScalargpuField& gcpsf
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(gcpsf),
    theta0_(gcpsf.theta0_)
{}


Foam::constantAlphaContactAngleFvPatchScalargpuField::
constantAlphaContactAngleFvPatchScalargpuField
(
    const constantAlphaContactAngleFvPatchScalargpuField& gcpsf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    alphaContactAngleTwoPhaseFvPatchScalargpuField(gcpsf, iF),
    theta0_(gcpsf.theta0_)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::tmp<Foam::scalargpuField>
Foam::constantAlphaContactAngleFvPatchScalargpuField::theta
(
    const fvPatchVectorgpuField&,
    const fvsPatchVectorgpuField&
) const
{
    return tmp<scalargpuField>::New(size(), theta0_);
}


void Foam::constantAlphaContactAngleFvPatchScalargpuField::write
(
    Ostream& os
) const
{
    alphaContactAngleTwoPhaseFvPatchScalargpuField::write(os);
    os.writeEntry("theta0", theta0_);
    writeEntry("value", os);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    makePatchTypeField
    (
        fvPatchScalargpuField,
        constantAlphaContactAngleFvPatchScalargpuField
    );
}

// ************************************************************************* //
