/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::opencc

Description
    An external GPU ODE solver for chemistry -- OpenCC

SourceFiles
    OpenCCSolver.C

\*---------------------------------------------------------------------------*/

#ifndef OpenCCSolver_H
#define OpenCCSolver_H

#include "chemistrySolver.H"

#include "opencc.h"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                            Class ode Declaration
\*---------------------------------------------------------------------------*/

template<class ChemistryModel>
class OpenCCSolver
:
    public chemistrySolver<ChemistryModel>
{
    // Private data

        dictionary coeffsDict_;


public:

    //- Runtime type information
    TypeName("OpenCCSolver");


    // Constructors

        //- Construct from thermo
        OpenCCSolver(typename ChemistryModel::reactionThermo& thermo);


    //- Destructor
    virtual ~OpenCCSolver();


    // Member Functions

        //- Update the concentrations and return the chemical time
        virtual void solve
        (
            scalargpuField& c,
            scalar& T,
            scalar& p,
            scalar& deltaT,
            scalar& subDeltaT
        ) const;


        virtual void solve
        (
            scalar*& Ynew,
            PtrList<volScalargpuField>& Y,
            scalar*& T,
            scalar*& p,
            scalar& t_init,
            scalar& t_end,
            label& num_cells
        ) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "OpenCCSolver.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
