/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "OpenCCSolver.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class ChemistryModel>
Foam::OpenCCSolver<ChemistryModel>::OpenCCSolver(typename ChemistryModel::reactionThermo& thermo)
:
    chemistrySolver<ChemistryModel>(thermo),
    coeffsDict_(this->subDict("odeCoeffs"))
{}


// * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * * //

template<class ChemistryModel>
Foam::OpenCCSolver<ChemistryModel>::~OpenCCSolver()
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class ChemistryModel>
void Foam::OpenCCSolver<ChemistryModel>::solve
(
    scalar*& Ynew,
    PtrList<volScalargpuField>& Y,
    scalar*& T,
    scalar*& p,
    scalar& t_init,
    scalar& t_end,
    label& num_cells
) const
{

   label num_species = this->nSpecie_;

    forAll(Y, speciesI) {
        volScalargpuField& Yi = Y[speciesI];
        scalargpuField& Yi_tmp = Yi.primitiveFieldRef();
        thrust::copy(Yi_tmp.begin(),Yi_tmp.end(), thrust::device_pointer_cast(this->d_y + speciesI*num_cells));
    }


    gpuList<scalar> index_result(num_species*num_cells);
    thrust::transform(
        thrust::counting_iterator<int>(0),
        thrust::counting_iterator<int>(num_species * num_cells),
        index_result.begin(),
        TransposeFunctor(num_species, num_cells)
    );

    thrust::gather(
        index_result.begin(),index_result.end(),
        thrust::device_pointer_cast(this->d_y),
        thrust::device_pointer_cast(this->d_y_t)
    );

    opencc_ode_all(T,p,this->d_y_t,t_init, t_end, GPU);

    gpuList<scalar> index_result2(num_species*num_cells);
    thrust::transform(
        thrust::counting_iterator<int>(0),
        thrust::counting_iterator<int>(num_species * num_cells),
        index_result2.begin(),
        TransposeFunctor(num_cells, num_species)
    );

    thrust::gather(
        index_result2.begin(),index_result2.end(),
        thrust::device_pointer_cast(this->d_y_t),
        thrust::device_pointer_cast(this->d_Ynew)
    );
}


template<class ChemistryModel>
void Foam::OpenCCSolver<ChemistryModel>::solve
(
    scalargpuField&,
    scalar&,
    scalar&,
    scalar&,
    scalar&
) const
{

}


// ************************************************************************* //
