/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2012 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "fvPatchgpuFieldMapper.H"
#include "volgpuFields.H"
#include "basicThermo.H"
#include "addToRunTimeSelectionTable.H"
#include "fixedEnergyFvPatchScalargpuField.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::fixedEnergyFvPatchScalargpuField::
fixedEnergyFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedValueFvPatchScalargpuField(p, iF)
{}


Foam::fixedEnergyFvPatchScalargpuField::
fixedEnergyFvPatchScalargpuField
(
    const fixedEnergyFvPatchScalargpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedValueFvPatchScalargpuField(ptf, p, iF, mapper)
{}


Foam::fixedEnergyFvPatchScalargpuField::
fixedEnergyFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedValueFvPatchScalargpuField(p, iF, dict)
{}


Foam::fixedEnergyFvPatchScalargpuField::
fixedEnergyFvPatchScalargpuField
(
    const fixedEnergyFvPatchScalargpuField& tppsf
)
:
    fixedValueFvPatchScalargpuField(tppsf)
{}


Foam::fixedEnergyFvPatchScalargpuField::
fixedEnergyFvPatchScalargpuField
(
    const fixedEnergyFvPatchScalargpuField& tppsf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedValueFvPatchScalargpuField(tppsf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::fixedEnergyFvPatchScalargpuField::updateCoeffs()
{
    if (updated())
    {
        return;
    }

    const basicThermo& thermo = basicThermo::lookupThermo(*this);
    const label patchi = patch().index();

    const scalargpuField& pw = thermo.p().boundaryField()[patchi];
    fvPatchScalargpuField& Tw =
        const_cast<fvPatchScalargpuField&>(thermo.T().boundaryField()[patchi]);
    Tw.evaluate();
    operator==(thermo.he(pw, Tw, patchi));

    fixedValueFvPatchScalargpuField::updateCoeffs();
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    makePatchTypeField
    (
        fvPatchScalargpuField,
        fixedEnergyFvPatchScalargpuField
    );
}

// ************************************************************************* //
