/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2012-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "addToRunTimeSelectionTable.H"
#include "energyJumpAMIFvPatchScalargpuField.H"
#include "fixedJumpAMIFvPatchgpuFields.H"
#include "basicThermo.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::energyJumpAMIFvPatchScalargpuField::energyJumpAMIFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedJumpAMIFvPatchgpuField<scalar>(p, iF)
{}


Foam::energyJumpAMIFvPatchScalargpuField::energyJumpAMIFvPatchScalargpuField
(
    const energyJumpAMIFvPatchScalargpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedJumpAMIFvPatchgpuField<scalar>(ptf, p, iF, mapper)
{}


Foam::energyJumpAMIFvPatchScalargpuField::energyJumpAMIFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedJumpAMIFvPatchgpuField<scalar>(p, iF)
{
    if (dict.found("value"))
    {
        fvPatchScalargpuField::operator=
        (
            scalargpuField("value", dict, p.size())
        );
    }
    else
    {
        evaluate(Pstream::commsTypes::blocking);
    }
}


Foam::energyJumpAMIFvPatchScalargpuField::energyJumpAMIFvPatchScalargpuField
(
    const energyJumpAMIFvPatchScalargpuField& ptf
)
:
    fixedJumpAMIFvPatchgpuField<scalar>(ptf)
{}


Foam::energyJumpAMIFvPatchScalargpuField::energyJumpAMIFvPatchScalargpuField
(
    const energyJumpAMIFvPatchScalargpuField& ptf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedJumpAMIFvPatchgpuField<scalar>(ptf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::energyJumpAMIFvPatchScalargpuField::updateCoeffs()
{
    if (this->updated())
    {
        return;
    }

    if (this->cyclicAMIPatch().owner())
    {
        const basicThermo& thermo = basicThermo::lookupThermo(*this);
        label patchID = patch().index();

        const scalargpuField& pp = thermo.p().boundaryField()[patchID];
        const fixedJumpAMIFvPatchScalargpuField& TbPatch =
            refCast<const fixedJumpAMIFvPatchScalargpuField>
            (
                thermo.T().boundaryField()[patchID]
            );

        fixedJumpAMIFvPatchScalargpuField& Tbp =
            const_cast<fixedJumpAMIFvPatchScalargpuField&>(TbPatch);

        // force update of jump
        Tbp.evaluate(Pstream::commsTypes::blocking);

        const labelgpuList& faceCells = this->patch().gpuFaceCells();

        jump_ = thermo.he(pp, Tbp.jump(), faceCells);
    }

    fixedJumpAMIFvPatchgpuField<scalar>::updateCoeffs();
}


void Foam::energyJumpAMIFvPatchScalargpuField::write(Ostream& os) const
{
    fixedJumpAMIFvPatchgpuField<scalar>::write(os);
    this->writeEntry("value", os);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
   makePatchTypeField
   (
       fvPatchScalargpuField,
       energyJumpAMIFvPatchScalargpuField
   );
}

// ************************************************************************* //
