/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2012-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "addToRunTimeSelectionTable.H"
#include "energyJumpFvPatchScalargpuField.H"
#include "fixedJumpFvPatchgpuFields.H"
#include "basicThermo.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::energyJumpFvPatchScalargpuField::energyJumpFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedJumpFvPatchgpuField<scalar>(p, iF)
{}


Foam::energyJumpFvPatchScalargpuField::energyJumpFvPatchScalargpuField
(
    const energyJumpFvPatchScalargpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedJumpFvPatchgpuField<scalar>(ptf, p, iF, mapper)
{}


Foam::energyJumpFvPatchScalargpuField::energyJumpFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedJumpFvPatchgpuField<scalar>(p, iF)
{
    if (dict.found("value"))
    {
        fvPatchScalargpuField::operator=
        (
            scalargpuField("value", dict, p.size())
        );
    }
    else
    {
        evaluate(Pstream::commsTypes::blocking);
    }
}


Foam::energyJumpFvPatchScalargpuField::energyJumpFvPatchScalargpuField
(
    const energyJumpFvPatchScalargpuField& ptf
)
:
    fixedJumpFvPatchgpuField<scalar>(ptf)
{}


Foam::energyJumpFvPatchScalargpuField::energyJumpFvPatchScalargpuField
(
    const energyJumpFvPatchScalargpuField& ptf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedJumpFvPatchgpuField<scalar>(ptf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::energyJumpFvPatchScalargpuField::updateCoeffs()
{
    if (this->updated())
    {
        return;
    }

    if (this->cyclicPatch().owner())
    {
        const basicThermo& thermo = basicThermo::lookupThermo(*this);
        label patchID = patch().index();

        const scalargpuField& pp = thermo.p().boundaryField()[patchID];
        const fixedJumpFvPatchScalargpuField& TbPatch =
            refCast<const fixedJumpFvPatchScalargpuField>
            (
                thermo.T().boundaryField()[patchID]
            );

        fixedJumpFvPatchScalargpuField& Tbp =
            const_cast<fixedJumpFvPatchScalargpuField&>(TbPatch);

        // force update of jump
        Tbp.evaluate(Pstream::commsTypes::blocking);

        const labelgpuList& faceCells = this->patch().gpuFaceCells();

        setJump(thermo.he(pp, Tbp.jump(), faceCells));
    }

    fixedJumpFvPatchgpuField<scalar>::updateCoeffs();
}


void Foam::energyJumpFvPatchScalargpuField::write(Ostream& os) const
{
    fixedJumpFvPatchgpuField<scalar>::write(os);
    this->writeEntry("value", os);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
   makePatchTypeField
   (
       fvPatchScalargpuField,
       energyJumpFvPatchScalargpuField
   );
}

// ************************************************************************* //
