/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpusurfaceInterpolationScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#define makeBasegpuSurfaceInterpolationScheme(Type)                               \
                                                                               \
defineNamedTemplateTypeNameAndDebug(gpusurfaceInterpolationScheme<Type>, 0);      \
                                                                               \
defineTemplateRunTimeSelectionTable                                            \
(                                                                              \
    gpusurfaceInterpolationScheme<Type>,                                          \
    Mesh                                                                       \
);                                                                             \
                                                                               \
defineTemplateRunTimeSelectionTable                                            \
(                                                                              \
    gpusurfaceInterpolationScheme<Type>,                                          \
    MeshFlux                                                                   \
);

makeBasegpuSurfaceInterpolationScheme(scalar)
makeBasegpuSurfaceInterpolationScheme(vector)
makeBasegpuSurfaceInterpolationScheme(sphericalTensor)
makeBasegpuSurfaceInterpolationScheme(symmTensor)
makeBasegpuSurfaceInterpolationScheme(tensor)

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<>
Foam::tmp
<
    Foam::GeometricgpuField
    <
        typename Foam::innerProduct<Foam::vector, Foam::scalar>::type,
        Foam::fvsPatchgpuField,
        Foam::gpusurfaceMesh
    >
>
Foam::gpusurfaceInterpolationScheme<Foam::scalar>::dotInterpolate
(
    const surfaceVectorgpuField& Sf,
    const GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>&
) const
{
    NotImplemented;

    return
        tmp
        <
            GeometricgpuField
            <
                typename innerProduct<vector, scalar>::type,
                fvsPatchgpuField,
                gpusurfaceMesh
            >
        >
        (
            GeometricgpuField
            <
                typename innerProduct<vector, scalar>::type,
                fvsPatchgpuField,
                gpusurfaceMesh
            >::null()
        );
}


// ************************************************************************* //
