/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fvc

Description
    Surface Interpolation

SourceFiles
    surfaceInterpolate.C

\*---------------------------------------------------------------------------*/

#ifndef gpusurfaceInterpolate_H
#define gpusurfaceInterpolate_H

#include "tmp.H"
#include "volgpuFieldsFwd.H"
#include "surfacegpuFieldsFwd.H"
#include "gpusurfaceInterpolationScheme.H"
#include "one.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Namespace fvc functions Declaration
\*---------------------------------------------------------------------------*/

namespace fvc
{
    //- Return weighting factors for scheme given from Istream
    template<class Type>
    static tmp<gpusurfaceInterpolationScheme<Type>> scheme
    (
        const surfaceScalargpuField& faceFlux,
        Istream& schemeData
    );

    //- Return weighting factors for scheme given by name in dictionary
    template<class Type>
    static tmp<gpusurfaceInterpolationScheme<Type>> scheme
    (
        const surfaceScalargpuField& faceFlux,
        const word& name
    );


    //- Return weighting factors for scheme given from Istream
    template<class Type>
    static tmp<gpusurfaceInterpolationScheme<Type>> scheme
    (
        const gpufvMesh& mesh,
        Istream& schemeData
    );

    //- Return weighting factors for scheme given by name in dictionary
    template<class Type>
    static tmp<gpusurfaceInterpolationScheme<Type>> scheme
    (
        const gpufvMesh& mesh,
        const word& name
    );


    //- Interpolate field onto faces using scheme given by Istream
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& tvf,
        const surfaceScalargpuField& faceFlux,
        Istream& schemeData
    );

    //- Interpolate field onto faces using scheme given by name in fvSchemes
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& tvf,
        const surfaceScalargpuField& faceFlux,
        const word& name
    );

    //- Interpolate field onto faces using scheme given by name in fvSchemes
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
        const surfaceScalargpuField& faceFlux,
        const word& name
    );

    //- Interpolate field onto faces using scheme given by name in fvSchemes
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& tvf,
        const tmp<surfaceScalargpuField>& faceFlux,
        const word& name
    );

    //- Interpolate field onto faces using scheme given by name in fvSchemes
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
        const tmp<surfaceScalargpuField>& faceFlux,
        const word& name
    );


    //- Interpolate field onto faces using scheme given by Istream
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& tvf,
        Istream& schemeData
    );

    //- Interpolate field onto faces using scheme given by name in fvSchemes
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& tvf,
        const word& name
    );

    //- Interpolate field onto faces using scheme given by name in fvSchemes
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
        const word& name
    );


    //- Interpolate field onto faces using 'interpolate(\<name\>)'
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& tvf
    );

    //- Interpolate tmp field onto faces using 'interpolate(\<name\>)'
    template<class Type>
    static tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
    (
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
    );


    //- Interpolate boundary field onto faces (simply a type conversion)
    template<class Type>
    static tmp<FieldField<fvsPatchgpuField, Type>> interpolate
    (
        const FieldField<fvPatchgpuField, Type>& fvpff
    );

    //- Interpolate boundary field onto faces (simply a type conversion)
    template<class Type>
    static tmp<FieldField<fvsPatchgpuField, Type>> interpolate
    (
        const tmp<FieldField<fvPatchgpuField, Type>>& tfvpff
    );

    //- Interpolate 'one' returning 'one'
/*    inline Foam::one interpolate(const Foam::one&)
    {
        return Foam::one{};
    }*/


    //- Interpolate field onto faces
    //  and 'dot' with given surfaceVectorField Sf
    template<class Type>
    static
    tmp
    <
        GeometricgpuField
        <
            typename innerProduct<vector, Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
            >
    > dotInterpolate
    (
        const surfaceVectorgpuField& Sf,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& tvf
    );

    //- Interpolate tmp field onto faces
    //  and 'dot' with given surfaceVectorField Sf
    template<class Type>
    static
    tmp
    <
        GeometricgpuField
        <
            typename innerProduct<vector, Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
            >
    > dotInterpolate
    (
        const surfaceVectorgpuField& Sf,
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
    );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpusurfaceInterpolate.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
