/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::upwind

Group
    grpFvLimitedSurfaceInterpolationSchemes

Description
    Upwind differencing scheme class.

SourceFiles
    upwind.C

\*---------------------------------------------------------------------------*/

#ifndef gpuupwind_H
#define gpuupwind_H

#include "gpulimitedSurfaceInterpolationScheme.H"
#include "volgpuFields.H"
#include "surfacegpuFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                           Class upwind Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class gpuupwind
:
    public gpulimitedSurfaceInterpolationScheme<Type>
{
    // Private Member Functions

        //- No copy assignment
        void operator=(const gpuupwind&) = delete;


public:

    //- Runtime type information
    TypeName("upwind");


    // Constructors

        //- Construct from faceFlux
        gpuupwind
        (
            const gpufvMesh& mesh,
            const surfaceScalargpuField& faceFlux
        )
        :
            gpulimitedSurfaceInterpolationScheme<Type>(mesh, faceFlux)
        {}

        //- Construct from Istream.
        //  The name of the flux field is read from the Istream and looked-up
        //  from the mesh objectRegistry
        gpuupwind
        (
            const gpufvMesh& mesh,
            Istream& is
        )
        :
            gpulimitedSurfaceInterpolationScheme<Type>(mesh, is)
        {}

        //- Construct from faceFlux and Istream
        gpuupwind
        (
            const gpufvMesh& mesh,
            const surfaceScalargpuField& faceFlux,
            Istream&
        )
        :
            gpulimitedSurfaceInterpolationScheme<Type>(mesh, faceFlux)
        {}


    // Member Functions

        //- Return the interpolation limiter
        virtual tmp<surfaceScalargpuField> limiter
        (
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const
        {
            return tmp<surfaceScalargpuField>::New
            (
                IOobject
                (
                    "upwindLimiter",
                    this->mesh().time().timeName(),
                    this->mesh().hostmesh(),
                    IOobject::NO_READ,
                    IOobject::NO_WRITE,
                    false
                ),
                this->mesh(),
                dimensionedScalar(dimless, Zero)
            );
        }

        //- Return the interpolation weighting factors
        tmp<surfaceScalargpuField> weights() const
        {
            return pos0(this->faceFlux_);
        }

        //- Return the interpolation weighting factors
        virtual tmp<surfaceScalargpuField> weights
        (
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const
        {
            return weights();
        }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
