/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "surfacegpuFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

defineTemplate2TypeNameAndDebug
(
    surfaceScalargpuField::Internal,
    0
);
defineTemplate2TypeNameAndDebug
(
    surfaceVectorgpuField::Internal,
    0
);
defineTemplate2TypeNameAndDebug
(
    surfaceSphericalTensorgpuField::Internal,
    0
);
defineTemplate2TypeNameAndDebug
(
    surfaceSymmTensorgpuField::Internal,
    0
);
defineTemplate2TypeNameAndDebug
(
    surfaceTensorgpuField::Internal,
    0
);


defineTemplateTypeNameWithName(surfaceScalargpuField, "surfaceScalarField");
defineTemplateDebugSwitchWithName(surfaceScalargpuField, "surfaceScalarField", 0);
   
defineTemplateTypeNameWithName(surfaceVectorgpuField, "surfaceVectorField");
defineTemplateDebugSwitchWithName(surfaceVectorgpuField, "surfaceVectorField", 0);

defineTemplateTypeNameWithName(surfaceSphericalTensorgpuField, "surfaceSphericalTensorField");
defineTemplateDebugSwitchWithName(surfaceSphericalTensorgpuField, "surfaceSphericalTensorField", 0);
 
defineTemplateTypeNameWithName(surfaceSymmTensorgpuField, "surfaceSymmTensorField");
defineTemplateDebugSwitchWithName(surfaceSymmTensorgpuField, "surfaceSymmTensorField", 0); 
 
defineTemplateTypeNameWithName(surfaceTensorgpuField, "surfaceTensorField");
defineTemplateDebugSwitchWithName(surfaceTensorgpuField, "surfaceTensorField", 0); 

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
