/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2012-2017 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "jumpCyclicAMIFvPatchgpuField.H"
#include "transformField.H"
//#include "gpulduAddressingFunctors.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class Type>
Foam::jumpCyclicAMIFvPatchgpuField<Type>::jumpCyclicAMIFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    cyclicAMIFvPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::jumpCyclicAMIFvPatchgpuField<Type>::jumpCyclicAMIFvPatchgpuField
(
    const jumpCyclicAMIFvPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    cyclicAMIFvPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::jumpCyclicAMIFvPatchgpuField<Type>::jumpCyclicAMIFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    cyclicAMIFvPatchgpuField<Type>(p, iF, dict)
{
    // Call this evaluation in derived classes
    //this->evaluate(Pstream::commsTypes::blocking);
}


template<class Type>
Foam::jumpCyclicAMIFvPatchgpuField<Type>::jumpCyclicAMIFvPatchgpuField
(
    const jumpCyclicAMIFvPatchgpuField<Type>& ptf
)
:
    cyclicAMIFvPatchgpuField<Type>(ptf)
{}


template<class Type>
Foam::jumpCyclicAMIFvPatchgpuField<Type>::jumpCyclicAMIFvPatchgpuField
(
    const jumpCyclicAMIFvPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    cyclicAMIFvPatchgpuField<Type>(ptf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::jumpCyclicAMIFvPatchgpuField<Type>::patchNeighbourField() const
{
    const gpuField<Type>& iField = this->primitiveField();
    const labelgpuList& nbrFaceCells =
        this->cyclicAMIPatch().cyclicAMIPatch().neighbPatch().gpuFaceCells();

    gpuField<Type> pnf(iField, nbrFaceCells);
    tmp<gpuField<Type>> tpnf;

    if (this->cyclicAMIPatch().applyLowWeightCorrection())
    {
        tpnf =
            this->cyclicAMIPatch().interpolate
            (
                pnf,
                this->patchInternalField()()
            );
    }
    else
    {
        tpnf = this->cyclicAMIPatch().interpolate(pnf);
    }

    if (this->doTransform())
    {
        tpnf = transform(this->gpuForwardT(), tpnf);
    }

    tmp<gpuField<Type>> tjf = jump();
    if (!this->cyclicAMIPatch().owner())
    {
        tjf = -tjf;
    }

    return tpnf - tjf;
}


template<class Type>
void Foam::jumpCyclicAMIFvPatchgpuField<Type>::updateInterfaceMatrix
(
    scalargpuField& result,
    const bool add,
    const gpulduAddressing& lduAddr,
    const label patchId,
    const scalargpuField& psiInternal,
    const scalargpuField& coeffs,
    const direction cmpt,
    const Pstream::commsTypes
) const
{
    NotImplemented;
}


template<class Type>
void Foam::jumpCyclicAMIFvPatchgpuField<Type>::updateInterfaceMatrix
(
    gpuField<Type>& result,
    const bool add,
    const gpulduAddressing& lduAddr,
    const label patchId,
    const gpuField<Type>& psiInternal,
    const scalargpuField& coeffs,
    const Pstream::commsTypes
) const
{
    const labelgpuList& nbrFaceCells =
        lduAddr.patchAddr
        (
            this->cyclicAMIPatch().neighbPatchID()
        );

    gpuField<Type> pnf(psiInternal, nbrFaceCells);

    if (this->cyclicAMIPatch().applyLowWeightCorrection())
    {
        pnf =
            this->cyclicAMIPatch().interpolate
            (
                pnf,
                this->patchInternalField()()
            );

    }
    else
    {
        pnf = this->cyclicAMIPatch().interpolate(pnf);
    }

    // only apply jump to original field
    if (&psiInternal == &this->primitiveField())
    {
        gpuField<Type> jf(this->jump());
        if (!this->cyclicAMIPatch().owner())
        {
            jf *= -1.0;
        }

        pnf -= jf;
    }

    // Transform according to the transformation tensors
    this->transformCoupleField(pnf);

    //const labelgpuList& faceCells = lduAddr.patchAddr(patchId);

    // Multiply the field by coefficients and add into the result
    //this->addToInternalField(result, !add,faceCells, coeffs, pnf);
    this->addToInternalField(result, !add, patchId, lduAddr, coeffs, pnf);
}


// ************************************************************************* //
