/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2017 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "slicedFvPatchgpuField.H"

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::slicedFvPatchgpuField<Type>::slicedFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const gpuField<Type>& completeField
)
:
    fvPatchgpuField<Type>(p, iF, gpuField<Type>())
{
    // Set the fvPatchgpuField to a slice of the given complete field
    gpuList<Type>::operator=(gpuList<Type>(completeField,p.size(),p.start()));
}


template<class Type>
Foam::slicedFvPatchgpuField<Type>::slicedFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    fvPatchgpuField<Type>(p, iF, Field<Type>())
{}


template<class Type>
Foam::slicedFvPatchgpuField<Type>::slicedFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fvPatchgpuField<Type>(p, iF, dict, false)
{
    NotImplemented;
}


template<class Type>
Foam::slicedFvPatchgpuField<Type>::slicedFvPatchgpuField
(
    const slicedFvPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fvPatchgpuField<Type>(ptf, p, iF, mapper)
{
    NotImplemented;
}


template<class Type>
Foam::slicedFvPatchgpuField<Type>::slicedFvPatchgpuField
(
    const slicedFvPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    fvPatchgpuField<Type>(ptf.patch(), iF, gpuField<Type>())
{
    // Transfer the slice from the argument
        gpuList<Type>::operator=(ptf);
}


template<class Type>
Foam::tmp<Foam::fvPatchgpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::clone() const
{
    return tmp<fvPatchgpuField<Type>>
    (
        new slicedFvPatchgpuField<Type>(*this)
    );
}


template<class Type>
Foam::slicedFvPatchgpuField<Type>::slicedFvPatchgpuField
(
    const slicedFvPatchgpuField<Type>& ptf
)
:
    fvPatchgpuField<Type>
    (
        ptf.patch(),
        ptf.internalField(),
        gpuField<Type>()
    )
{
    // Transfer the slice from the argument
    gpuList<Type>::operator=(ptf);
}


template<class Type>
Foam::tmp<Foam::fvPatchgpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::clone
(
    const DimensionedgpuField<Type, gpuvolMesh>& iF
) const
{
    return tmp<fvPatchgpuField<Type>>
    (
        new slicedFvPatchgpuField<Type>(*this, iF)
    );
}


template<class Type>
Foam::slicedFvPatchgpuField<Type>::~slicedFvPatchgpuField()
{
    // Set the fvPatchgpuField storage pointer to nullptr before its destruction
    // to protect the field it a slice of.
    gpuList<Type>::clear();
}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::tmp<Foam::gpuField<Type>> Foam::slicedFvPatchgpuField<Type>::snGrad() const
{
    NotImplemented;

    return gpuField<Type>::null();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::patchInternalField() const
{
    NotImplemented;

    return gpuField<Type>::null();
}


template<class Type>
void Foam::slicedFvPatchgpuField<Type>::patchInternalField(gpuField<Type>&) const
{
    NotImplemented;
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::patchNeighbourField
(
    const gpuField<Type>& iField
) const
{
    NotImplemented;

    return gpuField<Type>::null();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::patchNeighbourField() const
{
    NotImplemented;

    return gpuField<Type>::null();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::valueInternalCoeffs
(
    const tmp<scalargpuField>&
) const
{
    NotImplemented;

    return gpuField<Type>::null();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::valueBoundaryCoeffs
(
    const tmp<scalargpuField>&
) const
{
    NotImplemented;

    return gpuField<Type>::null();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::gradientInternalCoeffs() const
{
    NotImplemented;

    return gpuField<Type>::null();
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::slicedFvPatchgpuField<Type>::gradientBoundaryCoeffs() const
{
    NotImplemented;

    return gpuField<Type>::null();
}


template<class Type>
void Foam::slicedFvPatchgpuField<Type>::write(Ostream& os) const
{
    fvPatchgpuField<Type>::write(os);
    this->writeEntry("value", os);
}


// ************************************************************************* //
